/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.Api;
import appeng.helpers.CraftingPatternDetails;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class PackageCraftingPatternDetails
implements ICraftingPatternDetails {
    public final IPackagePattern pattern;
    public final ItemStack definition;
    public final IAEItemStack[] sparseInputs;
    public final IAEItemStack[] sparseOutputs;
    public final List<IAEItemStack> inputs;
    public final List<IAEItemStack> outputs;
    private int priority = 0;

    public PackageCraftingPatternDetails(IPackagePattern pattern) {
        this.pattern = pattern;
        this.definition = pattern.getOutput();
        this.definition.func_77978_p().func_74778_a("PatternType", "package");
        IItemStorageChannel storageChannel = (IItemStorageChannel)Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
        this.sparseInputs = (IAEItemStack[])pattern.getInputs().stream().map(arg_0 -> ((IItemStorageChannel)storageChannel).createStack(arg_0)).toArray(IAEItemStack[]::new);
        this.sparseOutputs = new IAEItemStack[]{(IAEItemStack)storageChannel.createStack((Object)pattern.getOutput())};
        this.inputs = AppEngUtil.condenseStacks(this.sparseInputs);
        this.outputs = ImmutableList.copyOf((Object[])this.sparseOutputs);
    }

    public ItemStack getPattern() {
        return this.definition;
    }

    public boolean isValidItemForSlot(int slotIndex, ItemStack itemStack, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public boolean isCraftable() {
        return false;
    }

    public List<IAEItemStack> getInputs() {
        return this.inputs;
    }

    public List<IAEItemStack> getOutputs() {
        return this.outputs;
    }

    public IAEItemStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    public IAEItemStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    public boolean canSubstitute() {
        return false;
    }

    public List<IAEItemStack> getSubstituteInputs(int index) {
        throw new IllegalStateException("Not supported.");
    }

    public ItemStack getOutput(CraftingInventory craftingInv, World world) {
        throw new IllegalStateException("Not supported.");
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public CraftingPatternDetails toAEInternal(World world) {
        ItemStack is;
        int i;
        ItemStack patternStack = new ItemStack((IItemProvider)Api.instance().definitions().items().encodedPattern());
        CompoundNBT encodedValue = new CompoundNBT();
        ListNBT tagIn = new ListNBT();
        ListNBT tagOut = new ListNBT();
        for (i = 0; i < 9; ++i) {
            is = i < this.pattern.getInputs().size() ? this.pattern.getInputs().get(i) : ItemStack.field_190927_a;
            tagIn.add((Object)PackageCraftingPatternDetails.createItemTag(is));
        }
        for (i = 0; i < 3; ++i) {
            is = i == 0 ? this.pattern.getOutput() : ItemStack.field_190927_a;
            tagOut.add((Object)PackageCraftingPatternDetails.createItemTag(is));
        }
        encodedValue.func_218657_a("in", (INBT)tagIn);
        encodedValue.func_218657_a("out", (INBT)tagOut);
        patternStack.func_77982_d(encodedValue);
        IAEItemStack patternAEStack = (IAEItemStack)((IItemStorageChannel)Api.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)patternStack);
        return new CraftingPatternDetails(patternAEStack, world);
    }

    private static INBT createItemTag(ItemStack i) {
        CompoundNBT c = new CompoundNBT();
        if (!i.func_190926_b()) {
            i.func_77955_b(c);
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageCraftingPatternDetails) {
            PackageCraftingPatternDetails other = (PackageCraftingPatternDetails)obj;
            return this.pattern.getIndex() == other.pattern.getIndex() && this.pattern.getRecipeInfo().equals(other.pattern.getRecipeInfo());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.pattern.getIndex(), this.pattern.getRecipeInfo());
    }
}

