/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.tile;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.networking.BaseGridBlock;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternDetails;
import thelm.packagedauto.tile.UnpackagerTile;

public class AEUnpackagerTile
extends UnpackagerTile
implements IGridHost,
IActionHost,
ICraftingProvider {
    public BaseGridBlock<AEUnpackagerTile> gridBlock = new BaseGridBlock<AEUnpackagerTile>(this);
    public IActionSource source = new MachineSource((IActionHost)this);
    public IGridNode gridNode;

    @Override
    public void func_73660_a() {
        if (this.firstTick && !this.field_145850_b.field_72995_K) {
            this.getActionableNode().updateState();
        }
        super.func_73660_a();
        if (drawMEEnergy && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    public IGridNode getActionableNode() {
        if (this.gridNode == null && !Platform.isClient()) {
            IAppEngApi api = Api.instance();
            this.gridNode = api.grid().createGridNode(this.gridBlock);
            if (this.ownerUUID != null) {
                this.gridNode.setPlayerID(api.registries().players().getID(new GameProfile(this.ownerUUID, "[UNKNOWN]")));
            }
        }
        return this.gridNode;
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, CraftingInventory table) {
        if (this.getActionableNode().isActive() && !this.isBusy()) {
            int i;
            IntArrayList emptySlots = new IntArrayList();
            for (int i2 = 0; i2 < 9; ++i2) {
                if (!this.itemHandler.getStackInSlot(i2).func_190926_b()) continue;
                emptySlots.add(i2);
            }
            IntArrayList requiredSlots = new IntArrayList();
            for (i = 0; i < table.func_70302_i_(); ++i) {
                if (table.func_70301_a(i).func_190926_b()) continue;
                requiredSlots.add(i);
            }
            if (requiredSlots.size() > emptySlots.size()) {
                return false;
            }
            for (i = 0; i < requiredSlots.size(); ++i) {
                this.itemHandler.setStackInSlot(emptySlots.getInt(i), table.func_70301_a(requiredSlots.getInt(i)).func_77946_l());
            }
            return true;
        }
        return false;
    }

    public boolean isBusy() {
        return Arrays.stream(this.trackers).limit(this.trackerCount).noneMatch(UnpackagerTile.PackageTracker::isEmpty);
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.getActionableNode().isActive()) {
            for (IPackageRecipeInfo pattern : this.recipeList) {
                if (pattern.getOutputs().isEmpty()) continue;
                craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)new RecipeCraftingPatternDetails(pattern).toAEInternal(this.field_145850_b));
            }
        }
    }

    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged event) {
        this.postPatternChange();
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange event) {
        this.postPatternChange();
    }

    @Override
    public void postPatternChange() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            grid.postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getActionableNode()));
        }
    }

    @Override
    protected boolean validSendTarget(TileEntity tile, Direction direction) {
        return super.validSendTarget(tile, direction) && !AppEngUtil.isInterface(tile, direction);
    }

    protected void chargeMEEnergy() {
        if (this.getActionableNode().isActive()) {
            IGrid grid = this.getActionableNode().getGrid();
            IEnergyGrid energyGrid = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
            double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyGrid.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyGrid.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        if (nbt.func_74764_b("Node")) {
            this.getActionableNode().loadFromNBT("Node", nbt);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT("Node", nbt);
        }
        return nbt;
    }
}

