/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.block.EncoderBlock;
import thelm.packagedauto.block.PackagerBlock;
import thelm.packagedauto.block.PackagerExtensionBlock;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.integration.jei.EncoderGhostIngredientHandler;
import thelm.packagedauto.integration.jei.EncoderGuiHandler;
import thelm.packagedauto.integration.jei.EncoderTransferHandler;
import thelm.packagedauto.integration.jei.PackageManagerPlugin;
import thelm.packagedauto.integration.jei.PackageRecipeTransferHandler;
import thelm.packagedauto.integration.jei.category.PackageContentsCategory;
import thelm.packagedauto.integration.jei.category.PackageProcessingCategory;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.integration.jei.category.PackagingCategory;

@JeiPlugin
public class PackagedAutoJEIPlugin
implements IModPlugin {
    public static final ResourceLocation UID = new ResourceLocation("packagedauto:jei");
    public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/jei.png");
    public static IJeiRuntime jeiRuntime;
    private static List<ResourceLocation> allCategories;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new PackageRecipeCategory(guiHelper), new PackagingCategory(guiHelper), new PackageProcessingCategory(guiHelper), new PackageContentsCategory(guiHelper)});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PackageRecipeTransferHandler(transferHelper), PackageRecipeCategory.UID);
        registration.addUniversalRecipeTransferHandler((IRecipeTransferHandler)new EncoderTransferHandler(transferHelper));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)EncoderBlock.INSTANCE), new ResourceLocation[]{PackageRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)PackagerBlock.INSTANCE), new ResourceLocation[]{PackagingCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)PackagerExtensionBlock.INSTANCE), new ResourceLocation[]{PackagingCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)UnpackagerBlock.INSTANCE), new ResourceLocation[]{PackageProcessingCategory.UID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(EncoderScreen.class, (IGuiContainerHandler)new EncoderGuiHandler());
        registration.addGhostIngredientHandler(EncoderScreen.class, (IGhostIngredientHandler)new EncoderGhostIngredientHandler());
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new PackageManagerPlugin());
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PackagedAutoJEIPlugin.jeiRuntime = jeiRuntime;
    }

    public static List<ResourceLocation> getAllRecipeCategories() {
        if (allCategories == null) {
            if (jeiRuntime == null) {
                return Collections.emptyList();
            }
            allCategories = jeiRuntime.getRecipeManager().getRecipeCategories(null, true).stream().map(IRecipeCategory::getUid).collect(Collectors.toList());
        }
        return allCategories;
    }
}

