/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.CrafterItemHandlerWrapper;
import thelm.packagedauto.tile.CrafterTile;

public class CrafterItemHandler
extends BaseItemHandler<CrafterTile> {
    public CrafterItemHandler(CrafterTile tile) {
        super(tile, 11);
    }

    public boolean isItemValid(int index, ItemStack stack) {
        if (index == 10) {
            return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
        }
        return false;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new CrafterItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int func_221476_a(int id) {
        switch (id) {
            case 0: {
                return ((CrafterTile)this.tile).remainingProgress;
            }
            case 1: {
                return ((CrafterTile)this.tile).isWorking ? 1 : 0;
            }
            case 2: {
                return ((CrafterTile)this.tile).getEnergyStorage().getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_221477_a(int id, int value) {
        switch (id) {
            case 0: {
                ((CrafterTile)this.tile).remainingProgress = value;
                break;
            }
            case 1: {
                ((CrafterTile)this.tile).isWorking = value != 0;
                break;
            }
            case 2: {
                ((CrafterTile)this.tile).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int func_221478_a() {
        return 3;
    }
}

