/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IProxyMarkerItem;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.tile.CraftingProxyTile;

public class CraftingProxyItemHandler
extends BaseItemHandler<CraftingProxyTile> {
    public CraftingProxyItemHandler(CraftingProxyTile tile) {
        super(tile, 1);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.loadMarker();
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IProxyMarkerItem && ((IProxyMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.loadMarker();
    }

    public void loadMarker() {
        ItemStack stack = this.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IProxyMarkerItem) {
            DirectionalGlobalPos pos = ((IProxyMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
            if (pos == null) {
                ((CraftingProxyTile)this.tile).target = null;
            } else if (((CraftingProxyTile)this.tile).func_145831_w() != null && !((CraftingProxyTile)this.tile).func_145831_w().func_234923_W_().equals(pos.dimension())) {
                ((CraftingProxyTile)this.tile).target = null;
            } else {
                BlockPos dirVec = pos.blockPos().func_177973_b((Vector3i)((CraftingProxyTile)this.tile).func_174877_v());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p())});
                if (dist <= CraftingProxyTile.range) {
                    ((CraftingProxyTile)this.tile).target = pos;
                }
            }
        } else {
            ((CraftingProxyTile)this.tile).target = null;
        }
    }
}

