/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.tile.DistributorTile;

public class DistributorItemHandler
extends BaseItemHandler<DistributorTile> {
    public DistributorItemHandler(DistributorTile tile) {
        super(tile, 81);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.loadMarker(slot);
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IDistributorMarkerItem && ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        for (int i = 0; i < 81; ++i) {
            this.loadMarker(i);
        }
    }

    public void loadMarker(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.func_77973_b() instanceof IDistributorMarkerItem) {
            DirectionalGlobalPos pos = ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
            if (pos == null) {
                ((DistributorTile)this.tile).positions.remove(slot);
            } else if (((DistributorTile)this.tile).func_145831_w() != null && !((DistributorTile)this.tile).func_145831_w().func_234923_W_().equals(pos.dimension())) {
                ((DistributorTile)this.tile).positions.remove(slot);
            } else {
                BlockPos dirVec = pos.blockPos().func_177973_b((Vector3i)((DistributorTile)this.tile).func_174877_v());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p())});
                if (dist <= DistributorTile.range) {
                    ((DistributorTile)this.tile).positions.put(slot, (Object)pos);
                }
            }
        } else {
            ((DistributorTile)this.tile).positions.remove(slot);
        }
    }
}

