/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.PackagerExtensionItemHandlerWrapper;
import thelm.packagedauto.tile.PackagerExtensionTile;
import thelm.packagedauto.tile.PackagerTile;

public class PackagerExtensionItemHandler
extends BaseItemHandler<PackagerExtensionTile> {
    public PackagerExtensionItemHandler(PackagerExtensionTile tile) {
        super(tile, 11);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot < 9 && !((PackagerExtensionTile)this.tile).func_145831_w().field_72995_K && ((PackagerExtensionTile)this.tile).isWorking && !this.getStackInSlot(slot).func_190926_b() && !((PackagerExtensionTile)this.tile).isInputValid()) {
            ((PackagerExtensionTile)this.tile).endProcess();
        }
        super.onContentsChanged(slot);
    }

    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 9: {
                return false;
            }
            case 10: {
                return stack.getCapability(CapabilityEnergy.ENERGY, null).isPresent();
            }
        }
        return ((PackagerExtensionTile)this.tile).isWorking ? !this.getStackInSlot(index).func_190926_b() : true;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new PackagerExtensionItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int func_221476_a(int id) {
        switch (id) {
            case 0: {
                return ((PackagerExtensionTile)this.tile).remainingProgress;
            }
            case 1: {
                return ((PackagerExtensionTile)this.tile).isWorking ? 1 : 0;
            }
            case 2: {
                return ((PackagerExtensionTile)this.tile).mode.ordinal();
            }
            case 3: {
                return ((PackagerExtensionTile)this.tile).getEnergyStorage().getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_221477_a(int id, int value) {
        switch (id) {
            case 0: {
                ((PackagerExtensionTile)this.tile).remainingProgress = value;
                break;
            }
            case 1: {
                ((PackagerExtensionTile)this.tile).isWorking = value != 0;
                break;
            }
            case 2: {
                ((PackagerExtensionTile)this.tile).mode = PackagerTile.Mode.values()[value];
                break;
            }
            case 3: {
                ((PackagerExtensionTile)this.tile).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int func_221478_a() {
        return 4;
    }
}

