/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.PackagerItemHandlerWrapper;
import thelm.packagedauto.tile.PackagerExtensionTile;
import thelm.packagedauto.tile.PackagerTile;
import thelm.packagedauto.util.MiscHelper;

public class PackagerItemHandler
extends BaseItemHandler<PackagerTile> {
    public PackagerItemHandler(PackagerTile tile) {
        super(tile, 12);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot < 9 && !((PackagerTile)this.tile).func_145831_w().field_72995_K && ((PackagerTile)this.tile).isWorking && !this.getStackInSlot(slot).func_190926_b() && !((PackagerTile)this.tile).isInputValid()) {
            ((PackagerTile)this.tile).endProcess();
        }
        if (slot == 10) {
            this.updatePatternList();
        }
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        if (slot == 10) {
            return 1;
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 9: {
                return false;
            }
            case 10: {
                return stack.func_77973_b() instanceof IPackageRecipeListItem || stack.func_77973_b() instanceof IPackageItem;
            }
            case 11: {
                return stack.getCapability(CapabilityEnergy.ENERGY, null).isPresent();
            }
        }
        return ((PackagerTile)this.tile).isWorking ? !this.getStackInSlot(slot).func_190926_b() : true;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new PackagerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int func_221476_a(int id) {
        switch (id) {
            case 0: {
                return ((PackagerTile)this.tile).remainingProgress;
            }
            case 1: {
                return ((PackagerTile)this.tile).isWorking ? 1 : 0;
            }
            case 2: {
                return ((PackagerTile)this.tile).mode.ordinal();
            }
            case 3: {
                return ((PackagerTile)this.tile).getEnergyStorage().getEnergyStored();
            }
        }
        return 0;
    }

    @Override
    public void func_221477_a(int id, int value) {
        switch (id) {
            case 0: {
                ((PackagerTile)this.tile).remainingProgress = value;
                break;
            }
            case 1: {
                ((PackagerTile)this.tile).isWorking = value != 0;
                break;
            }
            case 2: {
                ((PackagerTile)this.tile).mode = PackagerTile.Mode.values()[value];
                break;
            }
            case 3: {
                ((PackagerTile)this.tile).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int func_221478_a() {
        return 4;
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.updatePatternList();
    }

    public void updatePatternList() {
        ((PackagerTile)this.tile).patternList.clear();
        ItemStack listStack = this.getStackInSlot(10);
        if (listStack.func_77973_b() instanceof IPackageRecipeListItem) {
            ((IPackageRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList().stream().filter(IPackageRecipeInfo::isValid).forEach(recipe -> {
                recipe.getPatterns().forEach(((PackagerTile)this.tile).patternList::add);
                recipe.getExtraPatterns().forEach(((PackagerTile)this.tile).patternList::add);
            });
        } else if (listStack.func_77973_b() instanceof IPackageItem) {
            IPackageItem packageItem = (IPackageItem)listStack.func_77973_b();
            IPackageRecipeInfo recipe2 = packageItem.getRecipeInfo(listStack);
            int index = packageItem.getIndex(listStack);
            if (recipe2 != null && recipe2.isValid() && recipe2.validPatternIndex(index)) {
                ((PackagerTile)this.tile).patternList.add(recipe2.getPatterns().get(index));
            }
        }
        switch (((PackagerTile)this.tile).mode) {
            case EXACT: {
                ((PackagerTile)this.tile).disjoint = false;
                break;
            }
            case DISJOINT: {
                ((PackagerTile)this.tile).disjoint = MiscHelper.INSTANCE.arePatternsDisjoint(((PackagerTile)this.tile).patternList);
                break;
            }
            case FIRST: {
                ((PackagerTile)this.tile).disjoint = true;
            }
        }
        if (((PackagerTile)this.tile).func_145831_w() != null && !((PackagerTile)this.tile).func_145831_w().field_72995_K) {
            ((PackagerTile)this.tile).postPatternChange();
        }
        if (((PackagerTile)this.tile).func_145831_w() != null) {
            BlockPos.func_218281_b((BlockPos)((PackagerTile)this.tile).func_174877_v().func_177982_a(-1, -1, -1), (BlockPos)((PackagerTile)this.tile).func_174877_v().func_177982_a(1, 1, 1)).map(arg_0 -> ((World)((PackagerTile)this.tile).func_145831_w()).func_175625_s(arg_0)).filter(t -> t instanceof PackagerExtensionTile).map(t -> (PackagerExtensionTile)t).forEach(t -> t.updatePatternList());
        }
    }
}

