/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.PatternType;
import thelm.packagedauto.util.MiscHelper;

public class PackageItem
extends Item
implements IPackageItem {
    public static final PackageItem INSTANCE = new PackageItem();

    protected PackageItem() {
        super(new Item.Properties());
        this.setRegistryName("packagedauto:package");
    }

    public static ItemStack makePackage(IPackageRecipeInfo recipeInfo, int index) {
        ItemStack stack = new ItemStack((IItemProvider)INSTANCE);
        if (recipeInfo != null) {
            CompoundNBT tag = MiscHelper.INSTANCE.writeRecipe(new CompoundNBT(), recipeInfo);
            tag.func_74774_a("Index", (byte)index);
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_225608_bj_()) {
            ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
            ItemStack stack1 = stack.func_77979_a(1);
            IPackageRecipeInfo recipe = this.getRecipeInfo(stack1);
            int index = this.getIndex(stack1);
            if (recipe != null && recipe.validPatternIndex(index)) {
                List<ItemStack> inputs = recipe.getPatterns().get(index).getInputs();
                for (int i = 0; i < inputs.size(); ++i) {
                    ItemStack input = inputs.get(i).func_77946_l();
                    if (playerIn.field_71071_by.func_70441_a(input)) continue;
                    ItemEntity item = new ItemEntity(worldIn, playerIn.func_226277_ct_(), playerIn.func_226278_cu_(), playerIn.func_226281_cx_(), input);
                    item.func_200216_c(playerIn.func_110124_au());
                    worldIn.func_217376_c((Entity)item);
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        IPackageRecipeInfo recipe = this.getRecipeInfo(stack);
        int index = this.getIndex(stack);
        if (recipe != null && recipe.validPatternIndex(index)) {
            tooltip.add((ITextComponent)recipe.getRecipeType().getDisplayName().func_240702_b_(": "));
            for (ItemStack is : recipe.getOutputs()) {
                tooltip.add((ITextComponent)new StringTextComponent(is.func_190916_E() + " ").func_230529_a_(is.func_77946_l().func_151000_E()));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent("item.packagedauto.package.index", new Object[]{index}));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.packagedauto.package.items"));
            List<ItemStack> recipeInputs = recipe.getInputs();
            List<ItemStack> packageItems = recipeInputs.subList(9 * index, Math.min(9 * index + 9, recipeInputs.size()));
            for (ItemStack is : packageItems) {
                tooltip.add((ITextComponent)new StringTextComponent(is.func_190916_E() + " ").func_230529_a_(is.func_77946_l().func_151000_E()));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public IPackageRecipeInfo getRecipeInfo(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            return MiscHelper.INSTANCE.readRecipe(tag);
        }
        return null;
    }

    @Override
    public int getIndex(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74771_c("Index");
        }
        return -1;
    }

    @Override
    public PatternType getPatternType(ItemStack stack) {
        if (stack.func_77942_o()) {
            return PatternType.fromName(stack.func_77978_p().func_74779_i("PatternType"));
        }
        return null;
    }
}

