/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.util.PackageRecipeList;

public class RecipeHolderItem
extends Item
implements IPackageRecipeListItem {
    public static final RecipeHolderItem INSTANCE = new RecipeHolderItem();

    protected RecipeHolderItem() {
        super(new Item.Properties().func_200916_a(PackagedAuto.ITEM_GROUP));
        this.setRegistryName("packagedauto:recipe_holder");
    }

    @Override
    public IPackageRecipeList getRecipeList(ItemStack stack) {
        return new PackageRecipeList(stack.func_77978_p());
    }

    @Override
    public void setRecipeList(ItemStack stack, IPackageRecipeList recipeList) {
        stack.func_196082_o().func_82580_o("Recipes");
        if (recipeList != null) {
            recipeList.write(stack.func_77978_p());
        }
        if (stack.func_77978_p().isEmpty()) {
            stack.func_77982_d(null);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_225608_bj_() && this.isFilled(playerIn.func_184586_b(handIn))) {
            ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
            this.setRecipeList(stack, null);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            List<IPackageRecipeInfo> recipeList = this.getRecipeList(stack).getRecipeList();
            tooltip.add((ITextComponent)new TranslationTextComponent("item.packagedauto.recipe_holder.recipes"));
            for (IPackageRecipeInfo recipe : recipeList) {
                IFormattableTextComponent component = recipe.getRecipeType().getDisplayName().func_240702_b_(": ");
                for (int i = 0; i < recipe.getOutputs().size(); ++i) {
                    if (i != 0) {
                        component.func_240702_b_(", ");
                    }
                    ItemStack is = recipe.getOutputs().get(i);
                    component.func_240702_b_(is.func_190916_E() + " ").func_230529_a_(is.func_77946_l().func_151000_E());
                }
                tooltip.add((ITextComponent)component);
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean isFilled(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && !nbt.func_150295_c("Recipes", 10).isEmpty();
    }
}

