/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import thelm.packagedauto.container.EncoderContainer;
import thelm.packagedauto.tile.EncoderTile;

public class LoadRecipeListPacket {
    private final boolean single;
    private final boolean clear;

    public LoadRecipeListPacket(boolean single, boolean clear) {
        this.single = single;
        this.clear = clear;
    }

    public void encode(PacketBuffer buf) {
        buf.writeBoolean(this.single);
        buf.writeBoolean(this.clear);
    }

    public static LoadRecipeListPacket decode(PacketBuffer buf) {
        return new LoadRecipeListPacket(buf.readBoolean(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            if (player.field_71070_bA instanceof EncoderContainer) {
                EncoderContainer container = (EncoderContainer)player.field_71070_bA;
                ((EncoderTile)container.tile).loadRecipeList(this.single, this.clear);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

