/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.container.EmptyContainer;
import thelm.packagedauto.recipe.CraftingPackageRecipeType;
import thelm.packagedauto.recipe.ICraftingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class CraftingPackageRecipeInfo
implements ICraftingPackageRecipeInfo {
    ICraftingRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    CraftingInventory matrix = new CraftingInventory((Container)new EmptyContainer(), 3, 3);
    ItemStack output = ItemStack.field_190927_a;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void read(CompoundNBT nbt) {
        int i;
        this.input.clear();
        this.output = ItemStack.field_190927_a;
        this.patterns.clear();
        IRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().func_215367_a(new ResourceLocation(nbt.func_74779_i("Recipe"))).orElse(null);
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Matrix", 10), matrixList);
        for (i = 0; i < 9 && i < matrixList.size(); ++i) {
            this.matrix.func_70299_a(i, (ItemStack)matrixList.get(i));
        }
        if (recipe instanceof ICraftingRecipe) {
            this.recipe = (ICraftingRecipe)recipe;
            this.output = this.recipe.func_77572_b((IInventory)this.matrix).func_77946_l();
        }
        this.input.addAll(MiscHelper.INSTANCE.condenseStacks((IInventory)this.matrix));
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        if (this.recipe != null) {
            nbt.func_74778_a("Recipe", this.recipe.func_199560_c().toString());
        }
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            matrixList.add(this.matrix.func_70301_a(i));
        }
        ListNBT matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), matrixList);
        nbt.func_218657_a("Matrix", (INBT)matrixTag);
        return nbt;
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return CraftingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    @Override
    public ICraftingRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public CraftingInventory getMatrix() {
        return this.matrix;
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.func_179532_b((IInventory)this.matrix);
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = CraftingPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.func_190920_e(1);
            this.matrix.func_70299_a(i, toSet.func_77946_l());
        }
        ICraftingRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.matrix, world).orElse(null);
        if (recipe != null) {
            this.recipe = recipe;
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks((IInventory)this.matrix));
            this.output = recipe.func_77572_b((IInventory)this.matrix).func_77946_l();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add(new PackagePattern(this, i));
                ++i;
            }
            return;
        }
        this.matrix.func_174888_l();
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = CraftingPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            map.put(slotArray[i], (Object)this.matrix.func_70301_a(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CraftingPackageRecipeInfo) {
            CraftingPackageRecipeInfo other = (CraftingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, this.recipe, other, other.recipe);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, this.recipe);
    }
}

