/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IGuiIngredientWrapper;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeLayoutWrapper;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.recipe.ProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class ProcessingPackageRecipeType
implements IPackageRecipeType {
    public static final ProcessingPackageRecipeType INSTANCE = new ProcessingPackageRecipeType();
    public static final ResourceLocation NAME = new ResourceLocation("packagedauto:processing");
    public static final IntSet SLOTS;
    public static final Vector3i COLOR;
    public static final Vector3i COLOR_DISABLED;

    protected ProcessingPackageRecipeType() {
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent("recipe.packagedauto.processing");
    }

    @Override
    public IFormattableTextComponent getShortDisplayName() {
        return new TranslationTextComponent("recipe.packagedauto.processing.short");
    }

    @Override
    public IPackageRecipeInfo getNewRecipeInfo() {
        return new ProcessingPackageRecipeInfo();
    }

    @Override
    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    @Override
    public boolean canSetOutput() {
        return true;
    }

    @Override
    public boolean hasMachine() {
        return false;
    }

    @Override
    public List<ResourceLocation> getJEICategories() {
        return (List)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("jei"), () -> PackagedAutoJEIPlugin::getAllRecipeCategories, () -> Collections::emptyList).get();
    }

    @Override
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeLayoutWrapper recipeLayoutWrapper) {
        int i;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Map<Integer, IGuiIngredientWrapper<ItemStack>> ingredients = recipeLayoutWrapper.getItemStackIngredients();
        List<ItemStack> input = new ArrayList<ItemStack>();
        List<ItemStack> output = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, IGuiIngredientWrapper<ItemStack>> entry : ingredients.entrySet()) {
            IGuiIngredientWrapper<ItemStack> ingredient = entry.getValue();
            ItemStack displayed = entry.getValue().getDisplayedIngredient();
            if (displayed == null || displayed.func_190926_b()) continue;
            if (ingredient.isInput()) {
                input.add(displayed);
                continue;
            }
            output.add(displayed);
        }
        if (!this.isOrdered()) {
            input = MiscHelper.INSTANCE.condenseStacks(input);
        }
        output = MiscHelper.INSTANCE.condenseStacks(output);
        for (i = 0; i < input.size() && i < 81; ++i) {
            map.put(i, (Object)input.get(i));
        }
        for (i = 0; i < output.size() && i < 3; ++i) {
            map.put(i * 3 + 82, (Object)output.get(i));
        }
        return map;
    }

    @Override
    public Object getRepresentation() {
        return new ItemStack((IItemProvider)Blocks.field_150460_al);
    }

    @Override
    public Vector3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot)) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        COLOR = new Vector3i(139, 139, 139);
        COLOR_DISABLED = new Vector3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        IntStream.range(0, 81).forEachOrdered(arg_0 -> ((IntSet)SLOTS).add(arg_0));
        SLOTS.add(82);
        SLOTS.add(85);
        SLOTS.add(88);
    }
}

