/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.CrafterBlock;
import thelm.packagedauto.container.CrafterContainer;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.tile.AECrafterTile;
import thelm.packagedauto.inventory.CrafterItemHandler;
import thelm.packagedauto.recipe.ICraftingPackageRecipeInfo;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.tile.UnpackagerTile;
import thelm.packagedauto.util.MiscHelper;

public class CrafterTile
extends BaseTile
implements ITickableTileEntity,
IPackageCraftingMachine {
    public static final TileEntityType<CrafterTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AECrafterTile::new, () -> CrafterTile::new), (Block[])new Block[]{CrafterBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedauto:crafter");
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public ICraftingPackageRecipeInfo currentRecipe;

    public CrafterTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new CrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedauto.crafter");
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
                this.ejectItems();
            }
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof ICraftingPackageRecipeInfo) {
            ICraftingPackageRecipeInfo recipe = (ICraftingPackageRecipeInfo)recipeInfo;
            ItemStack slotStack = this.itemHandler.getStackInSlot(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.func_190926_b() || slotStack.func_77969_a(outputStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + outputStack.func_190916_E() <= outputStack.func_77976_d()) {
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.remainingProgress = energyReq;
                for (int i = 0; i < 9; ++i) {
                    this.itemHandler.setStackInSlot(i, recipe.getMatrix().func_70301_a(i).func_77946_l());
                }
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(9).func_190926_b()) {
            this.itemHandler.setStackInSlot(9, this.currentRecipe.getOutput());
        } else {
            this.itemHandler.getStackInSlot(9).func_190917_f(this.currentRecipe.getOutput().func_190916_E());
        }
        List<ItemStack> remainingItems = this.currentRecipe.getRemainingItems();
        for (int i = 0; i < 9; ++i) {
            this.itemHandler.setStackInSlot(i, remainingItems.get(i));
        }
        this.endProcess();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.currentRecipe = null;
        this.func_70296_d();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        for (Direction direction : Direction.values()) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (tile == null || tile instanceof UnpackagerTile || !tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()).resolve().get();
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(CapabilityEnergy.ENERGY, null).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 10).stream().allMatch(ItemStack::func_190926_b)) {
            return 15;
        }
        return 0;
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        CompoundNBT tag;
        IPackageRecipeInfo recipe;
        super.func_230337_a_(blockState, nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.remainingProgress = nbt.func_74762_e("Progress");
        this.currentRecipe = null;
        if (nbt.func_74764_b("Recipe") && (recipe = MiscHelper.INSTANCE.readRecipe(tag = nbt.func_74775_l("Recipe"))) instanceof ICraftingPackageRecipeInfo) {
            this.currentRecipe = (ICraftingPackageRecipeInfo)recipe;
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74768_a("Progress", this.remainingProgress);
        if (this.currentRecipe != null) {
            CompoundNBT tag = MiscHelper.INSTANCE.writeRecipe(new CompoundNBT(), this.currentRecipe);
            nbt.func_218657_a("Recipe", (INBT)tag);
        }
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new CrafterContainer(windowId, playerInventory, this);
    }
}

