/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.container.DistributorContainer;
import thelm.packagedauto.integration.appeng.tile.AEDistributorTile;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.tile.UnpackagerTile;
import thelm.packagedauto.util.MiscHelper;

public class DistributorTile
extends BaseTile
implements ITickableTileEntity,
IPackageCraftingMachine,
ISettingsCloneable {
    public static final TileEntityType<DistributorTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AEDistributorTile::new, () -> DistributorTile::new), (Block[])new Block[]{DistributorBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedauto:distributor");
    public static int range = 16;
    public static int refreshInterval = 4;
    public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap(81);
    public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap(81);
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();

    public DistributorTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new DistributorItemHandler(this));
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedauto.distributor");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.distributor";
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L && !this.pending.isEmpty()) {
            this.distributeItems();
        }
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo) {
            IPositionedProcessingPackageRecipeInfo recipe = (IPositionedProcessingPackageRecipeInfo)recipeInfo;
            boolean blocking = false;
            TileEntity unpackager = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (unpackager instanceof UnpackagerTile) {
                blocking = ((UnpackagerTile)unpackager).blocking;
            }
            Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
            if (!this.positions.keySet().containsAll((IntCollection)matrix.keySet())) {
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                BlockPos pos = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).blockPos();
                if (!this.field_145850_b.func_195588_v(pos)) {
                    return false;
                }
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (tile == null) {
                    return false;
                }
                ItemStack stack = ((ItemStack)entry.getValue()).func_77946_l();
                Direction dir = ((DirectionalGlobalPos)this.positions.get(entry.getIntKey())).direction();
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).orElse(null);
                if (itemHandler != null) {
                    if (blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
                        return false;
                    }
                    if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)true).func_190926_b()) continue;
                    return false;
                }
                return false;
            }
            for (Int2ObjectMap.Entry entry : matrix.int2ObjectEntrySet()) {
                this.pending.put(entry.getIntKey(), (Object)((ItemStack)entry.getValue()).func_77946_l());
            }
            this.distributeItems();
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        return !this.pending.isEmpty();
    }

    protected void distributeItems() {
        ArrayList<Vector3d> deltas = new ArrayList<Vector3d>();
        for (int i : this.pending.keySet().toIntArray()) {
            if (!this.positions.containsKey(i)) {
                this.ejectItems();
                break;
            }
            BlockPos pos = ((DirectionalGlobalPos)this.positions.get(i)).blockPos();
            if (!this.field_145850_b.func_195588_v(pos)) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile == null) {
                this.ejectItems();
                break;
            }
            ItemStack stack = (ItemStack)this.pending.get(i);
            Direction dir = ((DirectionalGlobalPos)this.positions.get(i)).direction();
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).orElse(null);
            ItemStack stackRem = stack;
            if (itemHandler == null) {
                this.ejectItems();
                break;
            }
            stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            if (stackRem.func_190916_E() < stack.func_190916_E()) {
                Vector3d delta = Vector3d.func_237491_b_((Vector3i)pos.func_177973_b((Vector3i)this.field_174879_c)).func_178787_e(Vector3d.func_237491_b_((Vector3i)dir.func_176730_m()).func_186678_a(0.5));
                deltas.add(delta);
            }
            if (stackRem.func_190926_b()) {
                this.pending.remove(i);
                continue;
            }
            this.pending.put(i, (Object)stackRem);
        }
        if (!deltas.isEmpty()) {
            Vector3d source = Vector3d.func_237489_a_((Vector3i)this.field_174879_c);
            BeamPacket.sendBeams(source, deltas, 65535, 6, true, (RegistryKey<World>)this.field_145850_b.func_234923_W_(), 32.0);
            this.func_70296_d();
        }
    }

    protected void ejectItems() {
        for (int i = 0; i < 81; ++i) {
            ItemStack stack;
            if (!this.pending.containsKey(i) || (stack = (ItemStack)this.pending.remove(i)).func_190926_b()) continue;
            double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
            double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + dx, (double)this.field_174879_c.func_177956_o() + dy, (double)this.field_174879_c.func_177952_p() + dz, stack);
            itemEntity.func_174869_p();
            this.field_145850_b.func_217376_c((Entity)itemEntity);
        }
        this.func_70296_d();
    }

    public void sendPreview(ServerPlayerEntity player) {
        long currentTime = this.field_145850_b.func_82737_E();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.func_110124_au());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            this.previewTimes.put((Object)player.func_110124_au(), (Object)currentTime);
            if (!this.positions.isEmpty()) {
                List<Vector3d> deltas = this.positions.values().stream().map(globalPos -> {
                    BlockPos pos = globalPos.blockPos();
                    Direction dir = globalPos.direction();
                    return Vector3d.func_237491_b_((Vector3i)pos.func_177973_b((Vector3i)this.field_174879_c)).func_72441_c((double)dir.func_82601_c() * 0.5, (double)dir.func_96559_d() * 0.5, (double)dir.func_82599_e() * 0.5);
                }).collect(Collectors.toList());
                Vector3d source = Vector3d.func_237489_a_((Vector3i)this.field_174879_c);
                DirectionalMarkerPacket.sendDirectionalMarkers(player, new ArrayList<DirectionalGlobalPos>((Collection<DirectionalGlobalPos>)this.positions.values()), 65407, 200);
                BeamPacket.sendBeams(player, source, deltas, 65407, 200, false);
            }
            Vector3d lowerCorner = Vector3d.func_237491_b_((Vector3i)this.field_174879_c).func_178786_a((double)range, (double)range, (double)range);
            Vector3d size = new Vector3d((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 65535, 200);
        }
    }

    @Override
    public int getComparatorSignal() {
        if (!this.pending.isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundNBT nbt, PlayerEntity player) {
        ItemStack stack;
        int i;
        PlayerInventory playerInventory;
        int requiredCount;
        ListNBT positionsTag;
        block13: {
            ItemStack stack2;
            int i2;
            positionsTag = nbt.func_150295_c("Positions", 10);
            if (positionsTag.isEmpty()) {
                return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("item.packagedauto.settings_cloner.invalid"));
            }
            requiredCount = positionsTag.size();
            int availableCount = 0;
            playerInventory = player.field_71071_by;
            for (i2 = 0; i2 < this.itemHandler.getSlots(); ++i2) {
                stack2 = this.itemHandler.getStackInSlot(i2);
                if (stack2.func_190926_b()) continue;
                if (stack2.func_77973_b() == DistributorMarkerItem.INSTANCE) {
                    availableCount += stack2.func_190916_E();
                    continue;
                }
                return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("block.packagedauto.distributor.non_marker_present"));
            }
            if (availableCount < requiredCount) {
                for (i2 = 0; i2 < playerInventory.func_70302_i_(); ++i2) {
                    stack2 = playerInventory.func_70301_a(i2);
                    if (!stack2.func_190926_b() && stack2.func_77973_b() == DistributorMarkerItem.INSTANCE && !stack2.func_77942_o()) {
                        availableCount += stack2.func_190916_E();
                    }
                    if (availableCount < requiredCount) {
                        continue;
                    }
                    break block13;
                }
                return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("block.packagedauto.distributor.no_markers"));
            }
        }
        int removedCount = 0;
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            removedCount += this.itemHandler.getStackInSlot(i).func_190916_E();
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        if (removedCount < requiredCount) {
            for (i = 0; i < playerInventory.func_70302_i_(); ++i) {
                ItemStack stack3 = playerInventory.func_70301_a(i);
                if (!stack3.func_190926_b() && stack3.func_77973_b() == DistributorMarkerItem.INSTANCE && !stack3.func_77942_o()) {
                    removedCount += stack3.func_77979_a(requiredCount - removedCount).func_190916_E();
                }
                if (removedCount >= requiredCount) break;
            }
        }
        if (removedCount > requiredCount && !playerInventory.func_70441_a(stack = new ItemStack((IItemProvider)DistributorMarkerItem.INSTANCE, removedCount - requiredCount))) {
            ItemEntity item = new ItemEntity(this.field_145850_b, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
            item.func_200216_c(player.func_110124_au());
            this.field_145850_b.func_217376_c((Entity)item);
        }
        for (int i3 = 0; i3 < requiredCount; ++i3) {
            CompoundNBT positionTag = positionsTag.func_150305_b(i3);
            byte index = positionTag.func_74771_c("Index");
            RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(positionTag.func_74779_i("Dimension")));
            int[] posArray = positionTag.func_74759_k("Position");
            BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            Direction direction = Direction.func_82600_a((int)positionTag.func_74771_c("Direction"));
            DirectionalGlobalPos globalPos = new DirectionalGlobalPos((RegistryKey<World>)dimension, blockPos, direction);
            ItemStack stack4 = new ItemStack((IItemProvider)DistributorMarkerItem.INSTANCE);
            DistributorMarkerItem.INSTANCE.setDirectionalGlobalPos(stack4, globalPos);
            this.itemHandler.setStackInSlot(index, stack4);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundNBT nbt, PlayerEntity player) {
        if (this.positions.isEmpty()) {
            return ISettingsCloneable.Result.fail((ITextComponent)new TranslationTextComponent("block.packagedauto.distributor.empty"));
        }
        ListNBT positionsTag = new ListNBT();
        for (Int2ObjectMap.Entry entry : this.positions.int2ObjectEntrySet()) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)entry.getValue();
            CompoundNBT positionTag = new CompoundNBT();
            positionTag.func_74774_a("Index", (byte)entry.getIntKey());
            positionTag.func_74778_a("Dimension", pos.dimension().func_240901_a_().toString());
            positionTag.func_74783_a("Position", new int[]{pos.x(), pos.y(), pos.z()});
            positionTag.func_74774_a("Direction", (byte)pos.direction().func_176745_a());
            positionsTag.add((Object)positionTag);
        }
        nbt.func_218657_a("Positions", (INBT)positionsTag);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.pending.clear();
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.func_150295_c("Pending", 10), pendingList);
        for (int i = 0; i < 81 && i < pendingList.size(); ++i) {
            ItemStack stack = (ItemStack)pendingList.get(i);
            if (stack.func_190926_b()) continue;
            this.pending.put(i, (Object)stack);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ArrayList<ItemStack> pendingList = new ArrayList<ItemStack>();
        for (int i = 0; i < 81; ++i) {
            pendingList.add((ItemStack)this.pending.getOrDefault(i, (Object)ItemStack.field_190927_a));
        }
        ListNBT pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListNBT(), pendingList);
        nbt.func_218657_a("Pending", (INBT)pendingTag);
        return nbt;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new DistributorContainer(windowId, playerInventory, this);
    }
}

