/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.block.EncoderBlock;
import thelm.packagedauto.container.EncoderContainer;
import thelm.packagedauto.inventory.EncoderItemHandler;
import thelm.packagedauto.inventory.EncoderPatternItemHandler;
import thelm.packagedauto.tile.BaseTile;

public class EncoderTile
extends BaseTile {
    public static final TileEntityType<EncoderTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a(EncoderTile::new, (Block[])new Block[]{EncoderBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedauto:encoder");
    public static int patternSlots = 20;
    public static Set<String> disabledRecipeTypes = Collections.emptySet();
    public final EncoderPatternItemHandler[] patternItemHandlers = new EncoderPatternItemHandler[patternSlots];
    public int patternIndex;

    public EncoderTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new EncoderItemHandler(this));
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            this.patternItemHandlers[i] = new EncoderPatternItemHandler(this);
        }
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedauto.encoder");
    }

    public void func_226984_a_(World world, BlockPos pos) {
        super.func_226984_a_(world, pos);
        for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
            inv.updateRecipeInfo(false);
        }
    }

    @Override
    public void readSync(CompoundNBT nbt) {
        super.readSync(nbt);
        this.patternIndex = nbt.func_74771_c("PatternIndex");
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            this.patternItemHandlers[i].read(nbt.func_74775_l(String.format("Pattern%02d", i)));
        }
    }

    @Override
    public CompoundNBT writeSync(CompoundNBT nbt) {
        super.writeSync(nbt);
        nbt.func_74774_a("PatternIndex", (byte)this.patternIndex);
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            CompoundNBT subNBT = new CompoundNBT();
            this.patternItemHandlers[i].write(subNBT);
            nbt.func_218657_a(String.format("Pattern%02d", i), (INBT)subNBT);
        }
        return nbt;
    }

    public void setPatternIndex(int patternIndex) {
        this.patternIndex = patternIndex;
        this.syncTile(false);
        this.func_70296_d();
    }

    public void saveRecipeList(boolean single) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_77973_b() instanceof IPackageRecipeListItem) {
            IPackageRecipeListItem recipeListItem = (IPackageRecipeListItem)stack.func_77973_b();
            IPackageRecipeList recipeListObj = recipeListItem.getRecipeList(stack);
            ArrayList<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
            if (!single) {
                for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
                    if (inv.recipeInfo == null) continue;
                    recipeList.add(inv.recipeInfo);
                }
            } else {
                EncoderPatternItemHandler inv = this.patternItemHandlers[this.patternIndex];
                if (inv.recipeInfo != null) {
                    recipeList.add(inv.recipeInfo);
                }
            }
            recipeListObj.setRecipeList(recipeList);
            recipeListItem.setRecipeList(stack, recipeListObj);
        }
    }

    public void loadRecipeList(boolean single, boolean clear) {
        block8: {
            block5: {
                List<IPackageRecipeInfo> recipeList;
                block6: {
                    EncoderPatternItemHandler inv;
                    block7: {
                        ItemStack stack = this.itemHandler.getStackInSlot(0);
                        if (!(stack.func_77973_b() instanceof IPackageRecipeListItem)) break block5;
                        IPackageRecipeList recipeListObj = ((IPackageRecipeListItem)stack.func_77973_b()).getRecipeList(stack);
                        recipeList = recipeListObj.getRecipeList();
                        if (!single) break block6;
                        inv = this.patternItemHandlers[this.patternIndex];
                        if (clear || recipeList.isEmpty()) break block7;
                        IPackageRecipeInfo recipe = recipeList.get(0);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) break block8;
                        inv.setRecipe(recipe.getEncoderStacks());
                        break block8;
                    }
                    inv.setRecipe(null);
                    break block8;
                }
                for (int i = 0; i < this.patternItemHandlers.length; ++i) {
                    EncoderPatternItemHandler inv = this.patternItemHandlers[i];
                    if (!clear && i < recipeList.size()) {
                        IPackageRecipeInfo recipe = recipeList.get(i);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) continue;
                        inv.setRecipe(recipe.getEncoderStacks());
                        continue;
                    }
                    inv.setRecipe(null);
                }
                break block8;
            }
            if (single) {
                this.patternItemHandlers[this.patternIndex].setRecipe(null);
            } else {
                for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
                    inv.setRecipe(null);
                }
            }
        }
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new EncoderContainer(windowId, playerInventory, this);
    }
}

