/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagerBlock;
import thelm.packagedauto.container.PackagerContainer;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.tile.AEPackagerTile;
import thelm.packagedauto.inventory.PackagerItemHandler;
import thelm.packagedauto.item.RecipeHolderItem;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.tile.UnpackagerTile;
import thelm.packagedauto.util.MiscHelper;

public class PackagerTile
extends BaseTile
implements ITickableTileEntity,
ISettingsCloneable {
    public static final TileEntityType<PackagerTile> TYPE_INSTANCE = (TileEntityType)TileEntityType.Builder.func_223042_a(MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("appliedenergistics2"), () -> AEPackagerTile::new, () -> PackagerTile::new), (Block[])new Block[]{PackagerBlock.INSTANCE}).func_206865_a(null).setRegistryName("packagedauto:packager");
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public List<IPackagePattern> patternList = new ArrayList<IPackagePattern>();
    public IPackagePattern currentPattern;
    public boolean lockPattern = false;
    public Mode mode = Mode.EXACT;
    public boolean disjoint = false;
    public boolean powered = false;

    public PackagerTile() {
        super(TYPE_INSTANCE);
        this.setItemHandler(new PackagerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected ITextComponent getDefaultName() {
        return new TranslationTextComponent("block.packagedauto.packager");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.packager";
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K) {
                this.postPatternChange();
            }
            this.updatePowered();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isInputValid()) {
                    this.finishProcess();
                    if (!this.itemHandler.getStackInSlot(9).func_190926_b()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L && !this.itemHandler.getStackInSlot(9).func_190926_b()) {
                this.ejectItem();
            }
        }
    }

    protected static Ingredient getIngredient(ItemStack stack) {
        return stack.func_77942_o() ? new NBTIngredient(stack){} : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
    }

    public boolean isInputValid() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            return false;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            return false;
        }
        if (!this.lockPattern && this.disjoint) {
            return MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), true);
        }
        List matchers = Lists.transform(this.currentPattern.getInputs(), PackagerTile::getIngredient);
        int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
        if (matches == null) {
            return false;
        }
        for (int i = 0; i < matches.length; ++i) {
            if (input.get(i).func_190916_E() >= this.currentPattern.getInputs().get(matches[i]).func_190916_E()) continue;
            return false;
        }
        return true;
    }

    protected boolean canStart() {
        this.getPattern();
        if (this.currentPattern == null) {
            return false;
        }
        if (!this.isInputValid()) {
            return false;
        }
        ItemStack slotStack = this.itemHandler.getStackInSlot(9);
        ItemStack outputStack = this.currentPattern.getOutput();
        return slotStack.func_190926_b() || slotStack.func_77969_a(outputStack) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.func_190916_E() + 1 <= outputStack.func_77976_d();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isInputValid();
    }

    protected void getPattern() {
        if (this.currentPattern != null && this.lockPattern) {
            return;
        }
        this.lockPattern = false;
        this.currentPattern = null;
        if (this.powered) {
            return;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            return;
        }
        for (IPackagePattern pattern : this.patternList) {
            if (this.disjoint) {
                if (!MiscHelper.INSTANCE.removeExactSet(input, pattern.getInputs(), true)) continue;
                this.currentPattern = pattern;
                return;
            }
            List matchers = Lists.transform(pattern.getInputs(), PackagerTile::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) continue;
            this.currentPattern = pattern;
            return;
        }
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            this.endProcess();
            return;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
        if (input.isEmpty()) {
            this.endProcess();
            return;
        }
        if (!this.lockPattern && this.disjoint) {
            if (!MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), true)) {
                this.endProcess();
                return;
            }
            if (this.itemHandler.getStackInSlot(9).func_190926_b()) {
                this.itemHandler.setStackInSlot(9, this.currentPattern.getOutput());
            } else if (this.itemHandler.getStackInSlot(9).func_77973_b() instanceof IPackageItem) {
                this.itemHandler.getStackInSlot(9).func_190917_f(1);
            } else {
                this.endProcess();
                return;
            }
            MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), false);
        } else {
            List matchers = Lists.transform(this.currentPattern.getInputs(), PackagerTile::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) {
                this.endProcess();
                return;
            }
            if (this.itemHandler.getStackInSlot(9).func_190926_b()) {
                this.itemHandler.setStackInSlot(9, this.currentPattern.getOutput());
            } else if (this.itemHandler.getStackInSlot(9).func_77973_b() instanceof IPackageItem) {
                this.itemHandler.getStackInSlot(9).func_190917_f(1);
            } else {
                this.endProcess();
                return;
            }
            for (int i = 0; i < matches.length; ++i) {
                input.get(i).func_190918_g(this.currentPattern.getInputs().get(matches[i]).func_190916_E());
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    protected void startProcess() {
        this.remainingProgress = energyReq;
        this.func_70296_d();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.lockPattern = false;
        this.func_70296_d();
    }

    protected void ejectItem() {
        for (Direction direction : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (!(te instanceof UnpackagerTile)) continue;
            UnpackagerTile tile = (UnpackagerTile)te;
            ItemStack stack = this.itemHandler.getStackInSlot(9);
            if (stack.func_190926_b()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)tile.itemHandler, (ItemStack)stack, (boolean)false);
            this.itemHandler.setStackInSlot(9, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(11);
        if (energyStack.getCapability(CapabilityEnergy.ENERGY, null).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.itemHandler.setStackInSlot(11, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.func_70296_d();
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStackInSlot(9).func_190926_b()) {
            return 15;
        }
        return 0;
    }

    public boolean canPushPattern() {
        return !this.isWorking && this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
    }

    public void postPatternChange() {
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundNBT nbt, PlayerEntity player) {
        TranslationTextComponent message;
        block5: {
            this.mode = Mode.values()[nbt.func_74771_c("Mode")];
            message = null;
            if (nbt.func_74764_b("Recipes")) {
                if (this.itemHandler.getStackInSlot(10).func_190926_b()) {
                    PlayerInventory playerInventory = player.field_71071_by;
                    for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                        ItemStack stack = playerInventory.func_70301_a(i);
                        if (stack.func_190926_b() || stack.func_77973_b() != RecipeHolderItem.INSTANCE || stack.func_77942_o()) continue;
                        ItemStack stackCopy = stack.func_77979_a(1);
                        IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stackCopy);
                        List<IPackageRecipeInfo> recipeList = MiscHelper.INSTANCE.readRecipeList(nbt.func_150295_c("Recipes", 10));
                        recipeListObj.setRecipeList(recipeList);
                        RecipeHolderItem.INSTANCE.setRecipeList(stackCopy, recipeListObj);
                        this.itemHandler.setStackInSlot(10, stackCopy);
                        break block5;
                    }
                    message = new TranslationTextComponent("block.packagedauto.packager.no_holders");
                } else {
                    message = new TranslationTextComponent("block.packagedauto.packager.holder_present");
                }
            }
        }
        if (message != null) {
            return ISettingsCloneable.Result.partial(message);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundNBT nbt, PlayerEntity player) {
        List<IPackageRecipeInfo> recipeList;
        nbt.func_74774_a("Mode", (byte)this.mode.ordinal());
        ItemStack listStack = this.itemHandler.getStackInSlot(10);
        if (listStack.func_77973_b() instanceof IPackageRecipeListItem && !(recipeList = ((IPackageRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList()).isEmpty()) {
            nbt.func_218657_a("Recipes", (INBT)MiscHelper.INSTANCE.writeRecipeList(new ListNBT(), recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        CompoundNBT tag;
        IPackageRecipeInfo recipe;
        this.mode = Mode.values()[nbt.func_74771_c("Mode")];
        super.func_230337_a_(blockState, nbt);
        this.isWorking = nbt.func_74767_n("Working");
        this.remainingProgress = nbt.func_74762_e("Progress");
        this.powered = nbt.func_74767_n("Powered");
        this.lockPattern = false;
        this.currentPattern = null;
        if (nbt.func_74764_b("Pattern") && (recipe = MiscHelper.INSTANCE.readRecipe(tag = nbt.func_74775_l("Pattern"))) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.func_74771_c("Index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
                this.lockPattern = true;
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Mode", (byte)this.mode.ordinal());
        nbt.func_74757_a("Working", this.isWorking);
        nbt.func_74768_a("Progress", this.remainingProgress);
        nbt.func_74757_a("Powered", this.powered);
        if (this.lockPattern) {
            CompoundNBT tag = MiscHelper.INSTANCE.writeRecipe(new CompoundNBT(), this.currentPattern.getRecipeInfo());
            tag.func_74774_a("Index", (byte)this.currentPattern.getIndex());
            nbt.func_218657_a("Pattern", (INBT)tag);
        }
        return nbt;
    }

    public void changePackagingMode() {
        this.mode = Mode.values()[(this.mode.ordinal() + 1) % 3];
        ((PackagerItemHandler)this.itemHandler).updatePatternList();
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (this.isWorking && !this.isInputValid()) {
            this.endProcess();
        }
        super.func_70296_d();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        this.syncTile(false);
        return new PackagerContainer(windowId, playerInventory, this);
    }

    public static enum Mode {
        EXACT,
        DISJOINT,
        FIRST;


        public ITextComponent getTooltip() {
            return new TranslationTextComponent("block.packagedauto.packager.mode." + this.name().toLowerCase(Locale.US));
        }
    }
}

