/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IMiscHelper;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.PackagedAutoApi;
import thelm.packagedauto.util.MiscHelper;

public class ApiImpl
extends PackagedAutoApi {
    public static final ApiImpl INSTANCE = new ApiImpl();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NavigableMap<ResourceLocation, IPackageRecipeType> REGISTRY = new TreeMap<ResourceLocation, IPackageRecipeType>();
    private static final Multimap<String, IPackageRecipeType> ORDER = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final IntIdentityHashBiMap<IPackageRecipeType> IDS = new IntIdentityHashBiMap(4);

    private ApiImpl() {
    }

    @Override
    public synchronized boolean registerRecipeType(IPackageRecipeType type) {
        if (REGISTRY.containsKey(type.getName())) {
            return false;
        }
        IDS.func_186812_a();
        REGISTRY.put(type.getName(), type);
        ORDER.put((Object)type.getName().func_110624_b(), (Object)type);
        return true;
    }

    @Override
    public IPackageRecipeType getRecipeType(ResourceLocation name) {
        return (IPackageRecipeType)REGISTRY.get(name);
    }

    @Override
    public IPackageRecipeType getRecipeType(int id) {
        this.computeIds();
        return (IPackageRecipeType)IDS.func_148745_a(id);
    }

    @Override
    public int getId(IPackageRecipeType type) {
        this.computeIds();
        return IDS.func_148757_b((Object)type);
    }

    private void computeIds() {
        if (IDS.func_186810_b() == 0) {
            ORDER.forEach((mod, type) -> IDS.func_186808_c(type));
        }
    }

    @Override
    public NavigableMap<ResourceLocation, IPackageRecipeType> getRecipeTypeRegistry() {
        return Collections.unmodifiableNavigableMap(REGISTRY);
    }

    @Override
    public IPackageRecipeType getNextRecipeType(IPackageRecipeType type, boolean reverse) {
        int toGet = Math.floorMod(this.getId(type) + (!reverse ? 1 : -1), REGISTRY.size());
        IPackageRecipeType ret = this.getRecipeType(toGet);
        return ret;
    }

    @Override
    public IMiscHelper miscHelper() {
        return MiscHelper.INSTANCE;
    }
}

