/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IMiscHelper;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.PackagedAutoApi;
import thelm.packagedauto.util.PackagePattern;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private static final Cache<CompoundNBT, IPackageRecipeInfo> RECIPE_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer server;

    private MiscHelper() {
    }

    @Override
    public List<ItemStack> condenseStacks(IInventory inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stacks.add(inventory.func_70301_a(i));
        }
        return this.condenseStacks((List<ItemStack>)stacks);
    }

    @Override
    public List<ItemStack> condenseStacks(IItemHandler itemHandler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(itemHandler.getSlots());
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            stacks.add(itemHandler.getStackInSlot(i));
        }
        return this.condenseStacks((List<ItemStack>)stacks);
    }

    @Override
    public List<ItemStack> condenseStacks(ItemStack ... stacks) {
        return this.condenseStacks(Arrays.asList(stacks));
    }

    @Override
    public List<ItemStack> condenseStacks(Stream<ItemStack> stacks) {
        return this.condenseStacks(stacks.collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> condenseStacks(Iterable<ItemStack> stacks) {
        return this.condenseStacks(stacks instanceof List ? (List)stacks : Lists.newArrayList(stacks));
    }

    @Override
    public List<ItemStack> condenseStacks(List<ItemStack> stacks) {
        return this.condenseStacks(stacks, false);
    }

    @Override
    public List<ItemStack> condenseStacks(List<ItemStack> stacks, boolean ignoreStackSize) {
        Object2IntRBTreeMap map = new Object2IntRBTreeMap(Comparator.comparing(pair -> Pair.of((Object)((Item)pair.getLeft()).getRegistryName(), (Object)("" + pair.getRight()))));
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            Pair pair2 = Pair.of((Object)stack.func_77973_b(), (Object)stack.func_77978_p());
            if (!map.containsKey((Object)pair2)) {
                map.put((Object)pair2, 0);
            }
            map.addTo((Object)pair2, stack.func_190916_E());
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int limit;
            ItemStack toAdd;
            int count;
            Pair pair3 = (Pair)entry.getKey();
            Item item = (Item)pair3.getLeft();
            CompoundNBT nbt = (CompoundNBT)pair3.getRight();
            if (ignoreStackSize) {
                toAdd = new ItemStack((IItemProvider)item, count);
                toAdd.func_77982_d(nbt);
                list.add(toAdd);
                continue;
            }
            for (count = entry.getIntValue(); count > 0; count -= limit) {
                toAdd = new ItemStack((IItemProvider)item, 1);
                toAdd.func_77982_d(nbt);
                limit = item.getItemStackLimit(toAdd);
                toAdd.func_190920_e(Math.min(count, limit));
                list.add(toAdd);
            }
        }
        map.clear();
        return list;
    }

    @Override
    public ListNBT saveAllItems(ListNBT tagList, List<ItemStack> list) {
        return this.saveAllItems(tagList, list, "Index");
    }

    @Override
    public ListNBT saveAllItems(ListNBT tagList, List<ItemStack> list, String indexKey) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            boolean empty = stack.func_190926_b();
            if (empty && i != list.size() - 1) continue;
            if (empty) {
                stack = new ItemStack((IItemProvider)((Item)null));
            }
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74774_a(indexKey, (byte)i);
            this.saveItemWithLargeCount(nbt, stack);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    @Override
    public void loadAllItems(ListNBT tagList, List<ItemStack> list) {
        this.loadAllItems(tagList, list, "Index");
    }

    @Override
    public void loadAllItems(ListNBT tagList, List<ItemStack> list, String indexKey) {
        list.clear();
        try {
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT nbt = tagList.func_150305_b(i);
                int j = nbt.func_74771_c(indexKey) & 0xFF;
                while (j >= list.size()) {
                    list.add(ItemStack.field_190927_a);
                }
                if (j < 0) continue;
                ItemStack stack = this.loadItemWithLargeCount(nbt);
                list.set(j, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
            }
        }
        catch (IndexOutOfBoundsException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public CompoundNBT saveItemWithLargeCount(CompoundNBT nbt, ItemStack stack) {
        stack.func_77955_b(nbt);
        int count = stack.func_190916_E();
        if ((byte)count == count) {
            nbt.func_74774_a("Count", (byte)count);
        } else if ((short)count == count) {
            nbt.func_74777_a("Count", (short)count);
        } else {
            nbt.func_74768_a("Count", (int)((short)count));
        }
        return nbt;
    }

    @Override
    public ItemStack loadItemWithLargeCount(CompoundNBT nbt) {
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)nbt);
        stack.func_190920_e(nbt.func_74762_e("Count"));
        return stack;
    }

    @Override
    public void writeItemWithLargeCount(PacketBuffer buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeBoolean(false);
            return;
        }
        buf.writeBoolean(true);
        buf.func_150787_b(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.func_150787_b(stack.func_190916_E());
        CompoundNBT nbt = null;
        if (stack.func_77973_b().isDamageable(stack) || stack.func_77973_b().func_77651_p()) {
            nbt = stack.getShareTag();
        }
        buf.func_150786_a(nbt);
    }

    @Override
    public ItemStack readItemWithLargeCount(PacketBuffer buf) {
        if (!buf.readBoolean()) {
            return ItemStack.field_190927_a;
        }
        int id = buf.func_150792_a();
        int count = buf.func_150792_a();
        ItemStack stack = new ItemStack((IItemProvider)Item.func_150899_d((int)id), count);
        stack.func_77973_b().readShareTag(stack, buf.func_150793_b());
        return stack;
    }

    @Override
    public IPackagePattern getPattern(IPackageRecipeInfo recipeInfo, int index) {
        return new PackagePattern(recipeInfo, index);
    }

    @Override
    public List<ItemStack> getRemainingItems(IInventory inventory) {
        return this.getRemainingItems(IntStream.range(0, inventory.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> getRemainingItems(IInventory inventory, int minInclusive, int maxExclusive) {
        return this.getRemainingItems(IntStream.range(minInclusive, maxExclusive).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> getRemainingItems(ItemStack ... stacks) {
        return this.getRemainingItems(Arrays.asList(stacks));
    }

    @Override
    public List<ItemStack> getRemainingItems(List<ItemStack> stacks) {
        NonNullList ret = NonNullList.func_191197_a((int)stacks.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)this.getContainerItem(stacks.get(i)));
        }
        return ret;
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            if (!(stack = stack.func_77973_b().getContainerItem(stack)).func_190926_b() && stack.func_77984_f() && stack.func_77952_i() > stack.func_77958_k()) {
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        if (stack.func_190916_E() > 1) {
            stack = stack.func_77946_l();
            stack.func_190920_e(stack.func_190916_E() - 1);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    @Override
    public boolean isEmpty(IItemHandler itemHandler) {
        if (itemHandler == null) {
            return false;
        }
        if (itemHandler.getSlots() == 0) {
            return false;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompoundNBT writeRecipe(CompoundNBT nbt, IPackageRecipeInfo recipe) {
        nbt.func_74778_a("RecipeType", recipe.getRecipeType().getName().toString());
        recipe.write(nbt);
        return nbt;
    }

    @Override
    public IPackageRecipeInfo readRecipe(CompoundNBT nbt) {
        IPackageRecipeType recipeType = PackagedAutoApi.instance().getRecipeType(new ResourceLocation(nbt.func_74779_i("RecipeType")));
        if (recipeType != null) {
            IPackageRecipeInfo recipe = (IPackageRecipeInfo)RECIPE_CACHE.getIfPresent((Object)nbt);
            if (recipe != null) {
                return recipe;
            }
            recipe = recipeType.getNewRecipeInfo();
            recipe.read(nbt);
            RECIPE_CACHE.put((Object)nbt, (Object)recipe);
            return recipe;
        }
        return null;
    }

    @Override
    public ListNBT writeRecipeList(ListNBT tagList, List<IPackageRecipeInfo> recipes) {
        for (IPackageRecipeInfo recipe : recipes) {
            tagList.add((Object)this.writeRecipe(new CompoundNBT(), recipe));
        }
        return tagList;
    }

    @Override
    public List<IPackageRecipeInfo> readRecipeList(ListNBT tagList) {
        ArrayList<IPackageRecipeInfo> recipes = new ArrayList<IPackageRecipeInfo>(tagList.size());
        for (int i = 0; i < tagList.size(); ++i) {
            IPackageRecipeInfo recipe = this.readRecipe(tagList.func_150305_b(i));
            if (recipe == null) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    @Override
    public boolean recipeEquals(IPackageRecipeInfo recipeA, Object recipeInternalA, IPackageRecipeInfo recipeB, Object recipeInternalB) {
        int i;
        if (!Objects.equals(recipeInternalA, recipeInternalB)) {
            return false;
        }
        List<ItemStack> inputsA = recipeA.getInputs();
        List<ItemStack> inputsB = recipeB.getInputs();
        if (inputsA.size() != inputsB.size()) {
            return false;
        }
        List<ItemStack> outputsA = recipeA.getOutputs();
        List<ItemStack> outputsB = recipeB.getOutputs();
        if (outputsA.size() != outputsB.size()) {
            return false;
        }
        for (i = 0; i < inputsA.size(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)inputsA.get(i), (ItemStack)inputsB.get(i))) continue;
            return false;
        }
        for (i = 0; i < outputsA.size(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)outputsA.get(i), (ItemStack)outputsB.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int recipeHashCode(IPackageRecipeInfo recipe, Object recipeInternal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean removeExactSet(List<ItemStack> offered, List<ItemStack> required, boolean simulate) {
        List<ItemStack> condensedRequired = this.condenseStacks(required, true);
        List<ItemStack> condensedOffered = this.condenseStacks(offered, true);
        block0: for (ItemStack req : condensedRequired) {
            for (ItemStack offer : condensedOffered) {
                if (req.func_190916_E() > offer.func_190916_E() || !req.func_77969_a(offer) || req.func_77942_o() && !ItemStack.func_77970_a((ItemStack)req, (ItemStack)offer)) continue;
                continue block0;
            }
            return false;
        }
        if (simulate) {
            return true;
        }
        for (ItemStack req : condensedRequired) {
            int count = req.func_190916_E();
            for (ItemStack offer : offered) {
                if (offer.func_190926_b() || !req.func_77969_a(offer) || req.func_77942_o() && !ItemStack.func_77970_a((ItemStack)req, (ItemStack)offer)) continue;
                int toRemove = Math.min(count, offer.func_190916_E());
                offer.func_190918_g(toRemove);
                if ((count -= toRemove) != 0) continue;
            }
        }
        return true;
    }

    @Override
    public boolean arePatternsDisjoint(List<IPackagePattern> patternList) {
        ObjectRBTreeSet set = new ObjectRBTreeSet(Comparator.comparing(pair -> Pair.of((Object)((Item)pair.getLeft()).getRegistryName(), (Object)("" + pair.getRight()))));
        for (IPackagePattern pattern : patternList) {
            List<ItemStack> condensedInputs = this.condenseStacks(pattern.getInputs(), true);
            for (ItemStack stack : condensedInputs) {
                Pair toAdd = Pair.of((Object)stack.func_77973_b(), (Object)stack.func_77978_p());
                if (set.contains((Object)toAdd)) {
                    return false;
                }
                set.add((Object)toAdd);
            }
        }
        set.clear();
        return true;
    }

    @Override
    public ItemStack insertItem(IItemHandler itemHandler, ItemStack stack, boolean requireEmptySlot, boolean simulate) {
        if (itemHandler == null || stack.func_190926_b()) {
            return stack;
        }
        if (!requireEmptySlot) {
            return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemHandler.getStackInSlot(slot).func_190926_b() || !(stack = itemHandler.insertItem(slot, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    public Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }

    public void setServer(MinecraftServer server) {
        MiscHelper.server = server;
    }

    @Override
    public RecipeManager getRecipeManager() {
        return server != null ? server.func_199529_aN() : (RecipeManager)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71441_e.func_199532_z());
    }
}

