/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.util.MiscHelper;

public class PackageRecipeList
implements IPackageRecipeList {
    private List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();

    public PackageRecipeList(CompoundNBT nbt) {
        this.read(nbt);
    }

    public PackageRecipeList(List<IPackageRecipeInfo> recipeList) {
        this.setRecipeList(recipeList);
    }

    @Override
    public List<IPackageRecipeInfo> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @Override
    public void setRecipeList(List<IPackageRecipeInfo> recipeList) {
        this.recipeList.clear();
        this.recipeList.addAll(recipeList);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.recipeList.clear();
        if (nbt != null) {
            this.recipeList.addAll(MiscHelper.INSTANCE.readRecipeList(nbt.func_150295_c("Recipes", 10)));
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        ListNBT tagList = MiscHelper.INSTANCE.writeRecipeList(new ListNBT(), this.recipeList);
        if (!tagList.isEmpty()) {
            nbt.func_218657_a("Recipes", (INBT)tagList);
        }
        return nbt;
    }
}

