/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagerExtensionBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagerExtensionBlockEntity;
import thelm.packagedauto.inventory.PackagerExtensionItemHandler;
import thelm.packagedauto.menu.PackagerExtensionMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagerExtensionBlockEntity
extends BaseBlockEntity
implements ISettingsCloneable {
    public static final BlockEntityType<PackagerExtensionBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AEPackagerExtensionBlockEntity::new, () -> () -> PackagerExtensionBlockEntity::new).get()), (Block[])new Block[]{PackagerExtensionBlock.INSTANCE}).m_58966_(null);
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public PackagerBlockEntity packager;
    public IItemHandlerModifiable listStackItemHandler = new ItemStackHandler(1);
    public List<IPackagePattern> patternList = new ArrayList<IPackagePattern>();
    public IPackagePattern currentPattern;
    public boolean lockPattern = false;
    public PackagerBlockEntity.Mode mode = PackagerBlockEntity.Mode.EXACT;
    public boolean disjoint = false;
    public boolean powered = false;

    public PackagerExtensionBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new PackagerExtensionItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.packager_extension");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.packager";
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.updatePatternList();
            this.updatePowered();
        }
        if (!this.f_58857_.f_46443_) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isInputValid()) {
                    this.finishProcess();
                    if (!this.itemHandler.getStackInSlot(9).m_41619_()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.f_58857_.m_46467_() % (long)refreshInterval == 0L && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % (long)refreshInterval == 0L && !this.itemHandler.getStackInSlot(9).m_41619_()) {
                this.ejectItem();
            }
        }
    }

    public boolean isInputValid() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            return false;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.m_41619_()).toList();
        if (input.isEmpty()) {
            return false;
        }
        if (!this.lockPattern && this.disjoint) {
            return MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), true);
        }
        List matchers = Lists.transform(this.currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
        int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
        if (matches == null) {
            return false;
        }
        for (int i = 0; i < matches.length; ++i) {
            if (input.get(i).m_41613_() >= this.currentPattern.getInputs().get(matches[i]).m_41613_()) continue;
            return false;
        }
        return true;
    }

    protected boolean canStart() {
        this.getPattern();
        if (this.currentPattern == null) {
            return false;
        }
        if (!this.isInputValid()) {
            return false;
        }
        ItemStack slotStack = this.itemHandler.getStackInSlot(9);
        ItemStack outputStack = this.currentPattern.getOutput();
        return slotStack.m_41619_() || ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.m_41613_() + 1 <= outputStack.m_41741_();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isInputValid();
    }

    protected void getPattern() {
        if (this.currentPattern != null && this.lockPattern) {
            return;
        }
        this.lockPattern = false;
        this.currentPattern = null;
        if (this.powered) {
            return;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.m_41619_()).toList();
        if (input.isEmpty()) {
            return;
        }
        for (IPackagePattern pattern : this.patternList) {
            if (this.disjoint) {
                if (!MiscHelper.INSTANCE.removeExactSet(input, pattern.getInputs(), true)) continue;
                this.currentPattern = pattern;
                return;
            }
            List matchers = Lists.transform(pattern.getInputs(), PackagerBlockEntity::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) continue;
            this.currentPattern = pattern;
            return;
        }
    }

    public void updatePatternList() {
        this.packager = null;
        this.listStackItemHandler.setStackInSlot(0, ItemStack.f_41583_);
        this.patternList.clear();
        if (this.f_58857_ != null) {
            for (BlockPos posP : BlockPos.m_121940_((BlockPos)this.f_58858_.m_7918_(-1, -1, -1), (BlockPos)this.f_58858_.m_7918_(1, 1, 1))) {
                PackagerBlockEntity packager;
                BlockEntity blockEntity = this.f_58857_.m_7702_(posP);
                if (!(blockEntity instanceof PackagerBlockEntity)) continue;
                this.packager = packager = (PackagerBlockEntity)blockEntity;
                ItemStack listStack = packager.itemHandler.getStackInSlot(10);
                this.listStackItemHandler.setStackInSlot(0, listStack);
                this.patternList.addAll(packager.patternList);
                this.disjoint = switch (this.mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case PackagerBlockEntity.Mode.EXACT -> false;
                    case PackagerBlockEntity.Mode.DISJOINT -> MiscHelper.INSTANCE.arePatternsDisjoint(this.patternList);
                    case PackagerBlockEntity.Mode.FIRST -> true;
                };
                break;
            }
        }
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentPattern == null) {
            this.getPattern();
        }
        if (this.currentPattern == null) {
            this.endProcess();
            return;
        }
        List<ItemStack> input = this.itemHandler.getStacks().subList(0, 9).stream().filter(stack -> !stack.m_41619_()).toList();
        if (input.isEmpty()) {
            this.endProcess();
            return;
        }
        if (!this.lockPattern && this.disjoint) {
            if (!MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), true)) {
                this.endProcess();
                return;
            }
            if (this.itemHandler.getStackInSlot(9).m_41619_()) {
                this.itemHandler.setStackInSlot(9, this.currentPattern.getOutput());
            } else if (this.itemHandler.getStackInSlot(9).m_41720_() instanceof IPackageItem) {
                this.itemHandler.getStackInSlot(9).m_41769_(1);
            } else {
                this.endProcess();
                return;
            }
            MiscHelper.INSTANCE.removeExactSet(input, this.currentPattern.getInputs(), false);
        } else {
            List matchers = Lists.transform(this.currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
            int[] matches = RecipeMatcher.findMatches(input, (List)matchers);
            if (matches == null) {
                this.endProcess();
                return;
            }
            if (this.itemHandler.getStackInSlot(9).m_41619_()) {
                this.itemHandler.setStackInSlot(9, this.currentPattern.getOutput());
            } else if (this.itemHandler.getStackInSlot(9).m_41720_() instanceof IPackageItem) {
                this.itemHandler.getStackInSlot(9).m_41769_(1);
            } else {
                this.endProcess();
                return;
            }
            for (int i = 0; i < matches.length; ++i) {
                input.get(i).m_41774_(this.currentPattern.getInputs().get(matches[i]).m_41613_());
            }
        }
        for (int i = 0; i < 9; ++i) {
            if (!this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    protected void startProcess() {
        this.remainingProgress = energyReq;
        this.m_6596_();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.lockPattern = false;
        this.m_6596_();
    }

    protected void ejectItem() {
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (!(blockEntity instanceof UnpackagerBlockEntity)) continue;
            UnpackagerBlockEntity unpackager = (UnpackagerBlockEntity)blockEntity;
            ItemStack stack = this.itemHandler.getStackInSlot(9);
            if (stack.m_41619_()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)unpackager.itemHandler, (ItemStack)stack, (boolean)false);
            this.itemHandler.setStackInSlot(9, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.f_41583_);
            }
        }
    }

    public void updatePowered() {
        if (this.f_58857_.m_277086_(this.f_58858_) > 0 != this.powered) {
            this.powered = !this.powered;
            this.sync(false);
            this.m_6596_();
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStackInSlot(9).m_41619_()) {
            return 15;
        }
        return 0;
    }

    public boolean canPushPattern() {
        return !this.isWorking && this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::m_41619_);
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
        this.mode = PackagerBlockEntity.Mode.values()[nbt.m_128445_("Mode")];
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
        IPackageRecipeListItem recipeListItem;
        List<IPackageRecipeInfo> recipeList;
        nbt.m_128344_("Mode", (byte)this.mode.ordinal());
        ItemStack listStack = this.listStackItemHandler.getStackInSlot(0);
        Item item = listStack.m_41720_();
        if (item instanceof IPackageRecipeListItem && !(recipeList = (recipeListItem = (IPackageRecipeListItem)item).getRecipeList(listStack).getRecipeList()).isEmpty()) {
            nbt.m_128365_("Recipes", (Tag)MiscHelper.INSTANCE.saveRecipeList(new ListTag(), recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        this.mode = PackagerBlockEntity.Mode.values()[nbt.m_128445_("Mode")];
        super.m_142466_(nbt);
        this.updatePatternList();
        this.isWorking = nbt.m_128471_("Working");
        this.remainingProgress = nbt.m_128451_("Progress");
        this.powered = nbt.m_128471_("Powered");
        this.lockPattern = false;
        this.currentPattern = null;
        if (nbt.m_128441_("Pattern") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.m_128469_("Pattern"))) != null) {
            List<IPackagePattern> patterns = recipe.getPatterns();
            byte index = tag.m_128445_("Index");
            if (index >= 0 && index < patterns.size()) {
                this.currentPattern = patterns.get(index);
                this.lockPattern = true;
            }
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128344_("Mode", (byte)this.mode.ordinal());
        nbt.m_128379_("Working", this.isWorking);
        nbt.m_128405_("Progress", this.remainingProgress);
        nbt.m_128379_("Powered", this.powered);
        if (this.lockPattern) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.currentPattern.getRecipeInfo());
            tag.m_128344_("Index", (byte)this.currentPattern.getIndex());
            nbt.m_128365_("Pattern", (Tag)tag);
        }
    }

    public void changePackagingMode() {
        this.mode = PackagerBlockEntity.Mode.values()[(this.mode.ordinal() + 1) % 3];
        this.updatePatternList();
        this.m_6596_();
    }

    public void m_6596_() {
        if (this.isWorking && !this.isInputValid()) {
            this.endProcess();
        }
        super.m_6596_();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new PackagerExtensionMenu(windowId, inventory, this);
    }
}

