/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class FluidRenderer {
    public static final FluidRenderer INSTANCE = new FluidRenderer(16, 16, 16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private final int width;
    private final int height;
    private final int minHeight;

    public FluidRenderer(int width, int height, int minHeight) {
        this.width = width;
        this.height = height;
        this.minHeight = minHeight;
    }

    private static TextureAtlasSprite getStillFluidSprite(FluidStack fluidStack) {
        ResourceLocation fluidStill = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMin += (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.setShader(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_252986_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public void render(GuiGraphics graphics, int xPosition, int yPosition, FluidStack fluidStack) {
        this.render(graphics, xPosition, yPosition, fluidStack, 1000);
    }

    public void render(GuiGraphics graphics, int xPosition, int yPosition, FluidStack fluidStack, int capacity) {
        RenderSystem.enableBlend();
        this.drawFluid(graphics, xPosition, yPosition, fluidStack, capacity);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private void drawFluid(GuiGraphics graphics, int xPosition, int yPosition, FluidStack fluidStack, int capacity) {
        if (capacity <= 0 || fluidStack == null || fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        TextureAtlasSprite fluidStillSprite = FluidRenderer.getStillFluidSprite(fluidStack);
        int fluidColor = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluidStack);
        int amount = fluidStack.getAmount();
        int scaledAmount = amount * this.height / capacity;
        if (amount > 0 && scaledAmount < this.minHeight) {
            scaledAmount = this.minHeight;
        }
        if (scaledAmount > this.height) {
            scaledAmount = this.height;
        }
        this.drawTiledSprite(graphics, xPosition, yPosition, this.width, this.height, fluidColor, scaledAmount, fluidStillSprite);
    }

    private void drawTiledSprite(GuiGraphics graphics, int xPosition, int yPosition, int tiledWidth, int tiledHeight, int color, int scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
        FluidRenderer.setGLColorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                FluidRenderer.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
            }
        }
    }
}

