/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.PacketHandler;

public record BeamPacket(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.source.f_82479_);
        buf.writeDouble(this.source.f_82480_);
        buf.writeDouble(this.source.f_82481_);
        buf.writeByte(this.deltas.size());
        for (Vec3 delta : this.deltas) {
            buf.writeDouble(delta.f_82479_);
            buf.writeDouble(delta.f_82480_);
            buf.writeDouble(delta.f_82481_);
        }
        buf.writeMedium(this.color);
        buf.writeShort(this.lifetime);
        buf.writeBoolean(this.fadeout);
    }

    public static BeamPacket decode(FriendlyByteBuf buf) {
        Vec3 source = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        int size = buf.readByte();
        ArrayList<Vec3> deltas = new ArrayList<Vec3>(size);
        for (int i = 0; i < size; ++i) {
            deltas.add(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
        return new BeamPacket(source, deltas, buf.readUnsignedMedium(), buf.readUnsignedShort(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> WorldOverlayRenderer.INSTANCE.addBeams(this.source, this.deltas, this.color, this.lifetime, this.fadeout));
        ctx.get().setPacketHandled(true);
    }

    public static void sendBeams(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout, ResourceKey<Level> dimension, double range) {
        PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(source.f_82479_, source.f_82480_, source.f_82481_, range, dimension)), (Object)new BeamPacket(source, deltas, color, lifetime, fadeout));
    }

    public static void sendBeams(ServerPlayer player, Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new BeamPacket(source, deltas, color, lifetime, fadeout));
    }
}

