/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.util.MiscHelper;

public class PackageRecipeList
implements IPackageRecipeList {
    private List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();

    public PackageRecipeList(CompoundTag nbt) {
        this.load(nbt);
    }

    public PackageRecipeList(List<IPackageRecipeInfo> recipeList) {
        this.setRecipeList(recipeList);
    }

    @Override
    public List<IPackageRecipeInfo> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @Override
    public void setRecipeList(List<IPackageRecipeInfo> recipeList) {
        this.recipeList.clear();
        this.recipeList.addAll(recipeList);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.recipeList.clear();
        if (nbt != null) {
            this.recipeList.addAll(MiscHelper.INSTANCE.loadRecipeList(nbt.m_128437_("Recipes", 10)));
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        ListTag tagList = MiscHelper.INSTANCE.saveRecipeList(new ListTag(), this.recipeList);
        if (!tagList.isEmpty()) {
            nbt.m_128365_("Recipes", (Tag)tagList);
        }
    }
}

