/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Max;
import de.maxhenkel.admiral.annotations.Min;
import de.maxhenkel.admiral.annotations.MinMax;
import de.maxhenkel.admiral.annotations.Name;
import de.maxhenkel.admiral.annotations.OptionalArgument;
import de.maxhenkel.admiral.impl.AdmiralArgumentType;
import de.maxhenkel.admiral.impl.AdmiralClass;
import de.maxhenkel.admiral.impl.AdmiralImpl;
import de.maxhenkel.admiral.impl.AdmiralMethod;
import de.maxhenkel.admiral.impl.ReflectionUtil;
import java.lang.reflect.Parameter;
import java.util.Optional;
import javax.annotation.Nullable;

public class AdmiralParameter<S, C, A, T> {
    private final AdmiralMethod<S, C> admiralMethod;
    private final Parameter parameter;
    private final String name;
    private final Class<T> type;
    private final AdmiralArgumentType<S, C, A, T> argumentType;
    private final boolean optional;

    public AdmiralParameter(AdmiralMethod<S, C> admiralMethod, Parameter parameter) {
        this.admiralMethod = admiralMethod;
        this.parameter = parameter;
        this.name = AdmiralParameter.getArgumentName(parameter);
        this.type = AdmiralParameter.isJavaOptional(parameter) ? ReflectionUtil.classFromType(parameter.getParameterizedType()) : parameter.getType();
        this.argumentType = AdmiralArgumentType.fromClass(this, this.type);
        this.optional = AdmiralParameter.isOptional(parameter);
    }

    private static String getArgumentName(Parameter parameter) {
        Name nameAnnotation = parameter.getDeclaredAnnotation(Name.class);
        return nameAnnotation != null ? nameAnnotation.value() : parameter.getName();
    }

    private static boolean isOptional(Parameter parameter) {
        if (AdmiralParameter.isJavaOptional(parameter)) {
            return true;
        }
        return parameter.getDeclaredAnnotation(OptionalArgument.class) != null;
    }

    private static boolean isJavaOptional(Parameter parameter) {
        return Optional.class.isAssignableFrom(parameter.getType());
    }

    public AdmiralArgumentType<S, C, A, T> getArgumentType() {
        return this.argumentType;
    }

    public AdmiralMethod<S, C> getAdmiralMethod() {
        return this.admiralMethod;
    }

    public AdmiralClass<S, C> getAdmiralClass() {
        return this.admiralMethod.getAdmiralClass();
    }

    public AdmiralImpl<S, C> getAdmiral() {
        return this.admiralMethod.getAdmiralClass().getAdmiral();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public RequiredArgumentBuilder<S, A> toArgument() {
        return RequiredArgumentBuilder.argument((String)this.name, this.argumentType.getArgumentType(this.getMin(), this.getMax())).suggests(this.argumentType.getSuggestionProvider());
    }

    public Object getValue(CommandContext<S> context) throws CommandSyntaxException {
        Object value;
        block3: {
            value = null;
            try {
                value = context.getArgument(this.name, Object.class);
            }
            catch (IllegalArgumentException e) {
                if (this.optional) break block3;
                throw e;
            }
        }
        Object convertedValue = this.argumentType.convert(context, value);
        if (AdmiralParameter.isJavaOptional(this.parameter)) {
            return Optional.ofNullable(convertedValue);
        }
        return convertedValue;
    }

    @Nullable
    private A getMin() {
        String value = null;
        MinMax minMax = this.parameter.getDeclaredAnnotation(MinMax.class);
        Min min = this.parameter.getDeclaredAnnotation(Min.class);
        if (minMax != null) {
            value = minMax.min();
        } else if (min != null) {
            value = min.value();
        }
        if (value == null) {
            return null;
        }
        return AdmiralParameter.parseString(value, this.argumentType.getArgumentTypeClass());
    }

    @Nullable
    private A getMax() {
        String value = null;
        MinMax minMax = this.parameter.getDeclaredAnnotation(MinMax.class);
        Max max = this.parameter.getDeclaredAnnotation(Max.class);
        if (minMax != null) {
            value = minMax.max();
        } else if (max != null) {
            value = max.value();
        }
        if (value == null) {
            return null;
        }
        return AdmiralParameter.parseString(value, this.argumentType.getArgumentTypeClass());
    }

    private static <A> A parseString(String value, Class<A> clazz) {
        if (Byte.class.isAssignableFrom(clazz)) {
            return (A)Byte.valueOf(Byte.parseByte(value));
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return (A)Byte.valueOf(Byte.parseByte(value));
        }
        if (Short.class.isAssignableFrom(clazz)) {
            return (A)Short.valueOf(Short.parseShort(value));
        }
        if (Short.TYPE.isAssignableFrom(clazz)) {
            return (A)Short.valueOf(Short.parseShort(value));
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return (A)Integer.valueOf(Integer.parseInt(value));
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return (A)Integer.valueOf(Integer.parseInt(value));
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return (A)Long.valueOf(Long.parseLong(value));
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return (A)Long.valueOf(Long.parseLong(value));
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return (A)Float.valueOf(Float.parseFloat(value));
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return (A)Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return (A)Double.valueOf(Double.parseDouble(value));
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return (A)Double.valueOf(Double.parseDouble(value));
        }
        return null;
    }
}

