/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import de.maxhenkel.admiral.impl.Log;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftLogging {
    public static final Logger LOGGER = LogManager.getLogger((String)Log.LOGGER.getName());

    public static void useMinecraftLogger() {
        Log.LOGGER.setUseParentHandlers(false);
        Log.LOGGER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                LOGGER.log(MinecraftLogging.fromJavaLogLevel(record.getLevel()), record.getMessage(), record.getThrown());
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
    }

    private static Level fromJavaLogLevel(java.util.logging.Level javaLevel) {
        if (javaLevel.equals(java.util.logging.Level.SEVERE)) {
            return Level.ERROR;
        }
        if (javaLevel.equals(java.util.logging.Level.WARNING)) {
            return Level.WARN;
        }
        if (javaLevel.equals(java.util.logging.Level.INFO)) {
            return Level.INFO;
        }
        if (javaLevel.equals(java.util.logging.Level.CONFIG)) {
            return Level.DEBUG;
        }
        if (javaLevel.equals(java.util.logging.Level.FINE)) {
            return Level.DEBUG;
        }
        if (javaLevel.equals(java.util.logging.Level.FINER)) {
            return Level.DEBUG;
        }
        if (javaLevel.equals(java.util.logging.Level.FINEST)) {
            return Level.TRACE;
        }
        return Level.INFO;
    }
}

