/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.commands.AdvancementCommands;
import net.minecraft.server.commands.ExecuteCommand;
import net.minecraft.server.commands.ItemCommands;

public class ReflectionSuggestionProviders {
    public static SuggestionProvider<CommandSourceStack> getAdvancementSuggestions() {
        return ReflectionSuggestionProviders.getFromClass(AdvancementCommands.class);
    }

    public static SuggestionProvider<CommandSourceStack> getPredicateSuggestions() {
        return ReflectionSuggestionProviders.getFromClass(ExecuteCommand.class);
    }

    public static SuggestionProvider<CommandSourceStack> getLootItemSuggestions() {
        return ReflectionSuggestionProviders.getFromClass(ItemCommands.class);
    }

    private static SuggestionProvider<CommandSourceStack> getFromClass(Class<?> clazz) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (field.getType() != SuggestionProvider.class) continue;
            field.setAccessible(true);
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            try {
                return (SuggestionProvider)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException(String.format("Could not find suggestion provider in class %s", clazz.getSimpleName()));
    }
}

