/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.admiral.arguments.GreedyString;
import de.maxhenkel.admiral.arguments.Word;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeConverter;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeRegistry;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeSupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class ArgumentTypeRegistryImpl
implements ArgumentTypeRegistry {
    private static final List<Consumer<ArgumentTypeRegistryImpl>> DEFAULT_REGISTRATIONS = new ArrayList<Consumer<ArgumentTypeRegistryImpl>>();
    private final Map<Class<?>, ArgumentTypeSupplier<?, ?, ?>> argumentTypeMap = new HashMap();
    private final Map<Class<?>, ArgumentTypeConverter<?, ?, ?>> argumentTypeConverterMap = new HashMap();

    public ArgumentTypeRegistryImpl() {
        this.registerDefault();
        for (Consumer<ArgumentTypeRegistryImpl> consumer : DEFAULT_REGISTRATIONS) {
            consumer.accept(this);
        }
    }

    public static void addRegistrations(Consumer<ArgumentTypeRegistryImpl> argumentRegistryConsumer) {
        DEFAULT_REGISTRATIONS.add(argumentRegistryConsumer);
    }

    private void registerDefault() {
        this.register(String.class, StringArgumentType::string);
        this.register(GreedyString.class, StringArgumentType::greedyString, (CommandContext<S> context, A value) -> new GreedyString((String)value));
        this.register(Word.class, StringArgumentType::word, (CommandContext<S> context, A value) -> new Word((String)value));
        this.register((min, max) -> {
            if (min == null) {
                min = Long.MIN_VALUE;
            }
            if (max == null) {
                max = Long.MAX_VALUE;
            }
            return LongArgumentType.longArg((long)min, (long)max);
        }, Long.class, Long.TYPE);
        this.register((min, max) -> {
            if (min == null) {
                min = Integer.MIN_VALUE;
            }
            if (max == null) {
                max = Integer.MAX_VALUE;
            }
            return IntegerArgumentType.integer((int)min, (int)max);
        }, Integer.class, Integer.TYPE);
        this.register((min, max) -> {
            if (min == null) {
                min = Double.MIN_VALUE;
            }
            if (max == null) {
                max = Double.MAX_VALUE;
            }
            return DoubleArgumentType.doubleArg((double)min, (double)max);
        }, Double.class, Double.TYPE);
        this.register((min, max) -> {
            if (min == null) {
                min = Float.valueOf(Float.MIN_VALUE);
            }
            if (max == null) {
                max = Float.valueOf(Float.MAX_VALUE);
            }
            return FloatArgumentType.floatArg((float)min.floatValue(), (float)max.floatValue());
        }, Float.class, Float.TYPE);
        this.register(BoolArgumentType::bool, Boolean.class, Boolean.TYPE);
    }

    @Nullable
    public <S, C, A, T> ArgumentTypeSupplier<S, C, A> getType(Class<T> clazz) {
        return this.argumentTypeMap.get(clazz);
    }

    @Nullable
    public <S, A, T> ArgumentTypeConverter<S, A, T> getConverter(Class<T> clazz) {
        return this.argumentTypeConverterMap.get(clazz);
    }

    @Override
    public <S, C, A, T> void register(Class<T> customTypeClass, ArgumentTypeSupplier<S, C, A> argumentType, @Nullable ArgumentTypeConverter<S, A, T> argumentTypeConverter) {
        this.argumentTypeMap.put(customTypeClass, argumentType);
        if (argumentTypeConverter != null) {
            this.argumentTypeConverterMap.put(customTypeClass, argumentTypeConverter);
        }
    }

    @Override
    public <S, C, A> void register(Class<A> argumentTypeClass, ArgumentTypeSupplier<S, C, A> argumentType) {
        this.register(argumentTypeClass, argumentType, null);
    }

    public <S, C, A> void register(ArgumentTypeSupplier<S, C, A> argumentType, Class<A> ... argumentTypeClass) {
        for (Class<A> clazz : argumentTypeClass) {
            this.register(clazz, argumentType, null);
        }
    }
}

