/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.maxhenkel.admiral.arguments.AttributeReference;
import de.maxhenkel.admiral.arguments.BiomeResourceOrTag;
import de.maxhenkel.admiral.arguments.ConfiguredFeatureReference;
import de.maxhenkel.admiral.arguments.EnchantmentReference;
import de.maxhenkel.admiral.arguments.Entities;
import de.maxhenkel.admiral.arguments.EntityReference;
import de.maxhenkel.admiral.arguments.LoadedBlockPos;
import de.maxhenkel.admiral.arguments.MobEffectReference;
import de.maxhenkel.admiral.arguments.OptionalEntities;
import de.maxhenkel.admiral.arguments.OptionalPlayers;
import de.maxhenkel.admiral.arguments.Players;
import de.maxhenkel.admiral.arguments.PoiTypeResourceOrTag;
import de.maxhenkel.admiral.arguments.ScoreHolder;
import de.maxhenkel.admiral.arguments.ScoreHolders;
import de.maxhenkel.admiral.arguments.Slot;
import de.maxhenkel.admiral.arguments.SpawnableBlockPos;
import de.maxhenkel.admiral.arguments.StructureReference;
import de.maxhenkel.admiral.arguments.StructureResourceOrTagKey;
import de.maxhenkel.admiral.arguments.StructureTemplatePoolReference;
import de.maxhenkel.admiral.arguments.SummonableEntityReference;
import de.maxhenkel.admiral.arguments.Swizzle;
import de.maxhenkel.admiral.arguments.Team;
import de.maxhenkel.admiral.arguments.Time;
import de.maxhenkel.admiral.arguments.UncenteredVec2;
import de.maxhenkel.admiral.arguments.UncenteredVec3;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeSupplier;
import de.maxhenkel.admiral.impl.ArgumentTypeRegistryImpl;
import de.maxhenkel.admiral.impl.CommandBiFunction;
import de.maxhenkel.admiral.impl.DynamicExceptionTypes;
import de.maxhenkel.admiral.impl.ReflectionSuggestionProviders;
import de.maxhenkel.admiral.impl.arguments.ReferenceBase;
import de.maxhenkel.admiral.impl.arguments.ResourceOrTagBase;
import de.maxhenkel.admiral.impl.arguments.ResourceOrTagKeyBase;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class MinecraftArgumentTypes {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        ArgumentTypeRegistryImpl.addRegistrations(MinecraftArgumentTypes::registerInternal);
        registered = true;
    }

    private static void registerInternal(ArgumentTypeRegistryImpl argumentRegistry) {
        argumentRegistry.register(Entity.class, EntityArgument::entity, (context, value) -> value.findSingleEntity((CommandSourceStack)context.getSource()));
        argumentRegistry.register(ServerPlayer.class, EntityArgument::player, (context, value) -> value.findSinglePlayer((CommandSourceStack)context.getSource()));
        argumentRegistry.register(Entities.class, EntityArgument::entities, (context, name, value) -> value == null ? null : new Entities(EntityArgument.getEntities((CommandContext)context, (String)name)));
        argumentRegistry.register(Players.class, EntityArgument::players, (context, name, value) -> value == null ? null : new Players(EntityArgument.getPlayers((CommandContext)context, (String)name)));
        argumentRegistry.register(OptionalEntities.class, EntityArgument::entities, (context, value) -> new OptionalEntities(value.findEntities((CommandSourceStack)context.getSource())));
        argumentRegistry.register(OptionalPlayers.class, EntityArgument::players, (context, value) -> new OptionalPlayers(value.findPlayers((CommandSourceStack)context.getSource())));
        argumentRegistry.register(ScoreHolder.class, ScoreHolderArgument::scoreHolder, (context, value) -> new ScoreHolder((ScoreHolderArgument.Result)value));
        argumentRegistry.register(ScoreHolders.class, ScoreHolderArgument::scoreHolders, (context, value) -> new ScoreHolders((ScoreHolderArgument.Result)value));
        argumentRegistry.register(Slot.class, SlotArgument::slot, (context, value) -> new Slot((Integer)value));
        argumentRegistry.register(Team.class, TeamArgument::team, (context, value) -> new Team((String)value));
        argumentRegistry.register(Time.class, (min, max) -> TimeArgument.time((int)(min == null ? 0 : min)), (context, value) -> new Time((Integer)value));
        argumentRegistry.register(BlockPos.class, BlockPosArgument::blockPos, (context, value) -> value.getBlockPos((CommandSourceStack)context.getSource()));
        argumentRegistry.register(LoadedBlockPos.class, BlockPosArgument::blockPos, (context, name, value) -> value == null ? null : new LoadedBlockPos(BlockPosArgument.getLoadedBlockPos((CommandContext)context, (String)name)));
        argumentRegistry.register(SpawnableBlockPos.class, BlockPosArgument::blockPos, (context, name, value) -> value == null ? null : new SpawnableBlockPos(BlockPosArgument.getSpawnablePos((CommandContext)context, (String)name)));
        argumentRegistry.register(ColumnPos.class, ColumnPosArgument::columnPos, (context, value) -> {
            BlockPos blockPos = value.getBlockPos((CommandSourceStack)context.getSource());
            return new ColumnPos(blockPos.getX(), blockPos.getZ());
        });
        argumentRegistry.register(de.maxhenkel.admiral.arguments.Rotation.class, RotationArgument::rotation, (context, value) -> new de.maxhenkel.admiral.arguments.Rotation(value.getRotation((CommandSourceStack)context.getSource())));
        argumentRegistry.register(Swizzle.class, SwizzleArgument::swizzle, (context, name, value) -> value == null ? null : new Swizzle(SwizzleArgument.getSwizzle((CommandContext)context, (String)name)));
        argumentRegistry.register(Vec2.class, Vec2Argument::vec2, (context, value) -> {
            Vec3 position = value.getPosition((CommandSourceStack)context.getSource());
            return new Vec2((float)position.x, (float)position.z);
        });
        argumentRegistry.register(UncenteredVec2.class, () -> Vec2Argument.vec2((boolean)false), (context, value) -> {
            Vec3 position = value.getPosition((CommandSourceStack)context.getSource());
            return new UncenteredVec2(new Vec2((float)position.x, (float)position.z));
        });
        argumentRegistry.register(Vec3.class, Vec3Argument::vec3, (context, value) -> value.getPosition((CommandSourceStack)context.getSource()));
        argumentRegistry.register(UncenteredVec3.class, () -> Vec3Argument.vec3((boolean)false), (context, value) -> new UncenteredVec3(value.getPosition((CommandSourceStack)context.getSource())));
        argumentRegistry.register(AngleArgument.SingleAngle.class, AngleArgument::angle);
        argumentRegistry.register(ChatFormatting.class, ColorArgument::color);
        argumentRegistry.register(Component.class, ComponentArgument::textComponent);
        argumentRegistry.register(CompoundTag.class, CompoundTagArgument::compoundTag);
        argumentRegistry.register(EntityAnchorArgument.Anchor.class, EntityAnchorArgument::anchor);
        argumentRegistry.register(GameType.class, GameModeArgument::gameMode);
        argumentRegistry.register(GameProfileArgument.Result.class, GameProfileArgument::gameProfile);
        argumentRegistry.register(Heightmap.Types.class, HeightmapTypeArgument::heightmap);
        argumentRegistry.register(MessageArgument.Message.class, MessageArgument::message);
        argumentRegistry.register(NbtPathArgument.NbtPath.class, NbtPathArgument::nbtPath);
        argumentRegistry.register(Tag.class, NbtTagArgument::nbtTag);
        argumentRegistry.register(ObjectiveCriteria.class, ObjectiveCriteriaArgument::criteria);
        argumentRegistry.register(OperationArgument.Operation.class, OperationArgument::operation);
        argumentRegistry.register(ResourceLocation.class, ResourceLocationArgument::id);
        argumentRegistry.register(Mirror.class, TemplateMirrorArgument::templateMirror);
        argumentRegistry.register(Rotation.class, TemplateRotationArgument::templateRotation);
        argumentRegistry.register(UUID.class, UuidArgument::uuid);
        argumentRegistry.register(FunctionArgument.Result.class, new ArgumentTypeSupplier<CommandSourceStack, CommandBuildContext, FunctionArgument.Result>(){

            @Override
            public ArgumentType<FunctionArgument.Result> get() {
                return FunctionArgument.functions();
            }

            @Override
            public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
                return FunctionCommand.SUGGEST_FUNCTION;
            }
        });
        argumentRegistry.register(DisplaySlot.class, ScoreboardSlotArgument::displaySlot);
        argumentRegistry.register(BlockPredicateArgument.Result.class, ctx -> ctx == null ? null : BlockPredicateArgument.blockPredicate((CommandBuildContext)ctx));
        argumentRegistry.register(BlockInput.class, ctx -> ctx == null ? null : BlockStateArgument.block((CommandBuildContext)ctx));
        argumentRegistry.register(ParticleOptions.class, ctx -> ctx == null ? null : ParticleArgument.particle((CommandBuildContext)ctx));
        argumentRegistry.register(ItemInput.class, ctx -> ctx == null ? null : ItemArgument.item((CommandBuildContext)ctx));
        argumentRegistry.register(ItemPredicateArgument.Result.class, ctx -> ctx == null ? null : ItemPredicateArgument.itemPredicate((CommandBuildContext)ctx));
        argumentRegistry.register(ServerLevel.class, DimensionArgument::dimension, (context, name, value) -> value == null ? null : DimensionArgument.getDimension((CommandContext)context, (String)name));
        argumentRegistry.register(Objective.class, ObjectiveArgument::objective, (context, name, value) -> value == null ? null : ObjectiveArgument.getObjective((CommandContext)context, (String)name));
        argumentRegistry.register(Advancement.class, new ArgumentTypeSupplier<CommandSourceStack, CommandBuildContext, ResourceLocation>(){

            @Override
            public ArgumentType<ResourceLocation> get() {
                return ResourceLocationArgument.id();
            }

            @Override
            public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
                return ReflectionSuggestionProviders.getAdvancementSuggestions();
            }
        }, (context, name, value) -> value == null ? null : ResourceLocationArgument.getAdvancement((CommandContext)context, (String)name));
        argumentRegistry.register(Recipe.class, new ArgumentTypeSupplier<CommandSourceStack, CommandBuildContext, ResourceLocation>(){

            @Override
            public ArgumentType<ResourceLocation> get() {
                return ResourceLocationArgument.id();
            }

            @Override
            public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
                return SuggestionProviders.ALL_RECIPES;
            }
        }, (context, name, value) -> value == null ? null : ResourceLocationArgument.getRecipe((CommandContext)context, (String)name));
        argumentRegistry.register(LootItemCondition.class, new ArgumentTypeSupplier<CommandSourceStack, CommandBuildContext, ResourceLocation>(){

            @Override
            public ArgumentType<ResourceLocation> get() {
                return ResourceLocationArgument.id();
            }

            @Override
            public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
                return ReflectionSuggestionProviders.getPredicateSuggestions();
            }
        }, (context, name, value) -> value == null ? null : ResourceLocationArgument.getPredicate((CommandContext)context, (String)name));
        argumentRegistry.register(LootItemFunction.class, new ArgumentTypeSupplier<CommandSourceStack, CommandBuildContext, ResourceLocation>(){

            @Override
            public ArgumentType<ResourceLocation> get() {
                return ResourceLocationArgument.id();
            }

            @Override
            public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
                return ReflectionSuggestionProviders.getLootItemSuggestions();
            }
        }, (context, name, value) -> value == null ? null : ResourceLocationArgument.getItemModifier((CommandContext)context, (String)name));
        MinecraftArgumentTypes.registerResourceReference(argumentRegistry, AttributeReference.class, () -> Registries.ATTRIBUTE, (ctx, name) -> new AttributeReference((Holder.Reference<Attribute>)ResourceArgument.getAttribute((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceReference(argumentRegistry, EntityReference.class, () -> Registries.ENTITY_TYPE, (ctx, name) -> new EntityReference((Holder.Reference<EntityType<?>>)ResourceArgument.getEntityType((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceReference(argumentRegistry, SummonableEntityReference.class, () -> Registries.ENTITY_TYPE, (ctx, name) -> new SummonableEntityReference((Holder.Reference<EntityType<?>>)ResourceArgument.getSummonableEntityType((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceReference(argumentRegistry, MobEffectReference.class, () -> Registries.MOB_EFFECT, (ctx, name) -> new MobEffectReference((Holder.Reference<MobEffect>)ResourceArgument.getMobEffect((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceReference(argumentRegistry, EnchantmentReference.class, () -> Registries.ENCHANTMENT, (ctx, name) -> new EnchantmentReference((Holder.Reference<Enchantment>)ResourceArgument.getEnchantment((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceKeyReference(argumentRegistry, ConfiguredFeatureReference.class, () -> Registries.CONFIGURED_FEATURE, (ctx, name) -> new ConfiguredFeatureReference((Holder.Reference<ConfiguredFeature<?, ?>>)ResourceKeyArgument.getConfiguredFeature((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceKeyReference(argumentRegistry, StructureReference.class, () -> Registries.STRUCTURE, (ctx, name) -> new StructureReference((Holder.Reference<Structure>)ResourceKeyArgument.getStructure((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceKeyReference(argumentRegistry, StructureTemplatePoolReference.class, () -> Registries.TEMPLATE_POOL, (ctx, name) -> new StructureTemplatePoolReference((Holder.Reference<StructureTemplatePool>)ResourceKeyArgument.getStructureTemplatePool((CommandContext)ctx, (String)name)));
        MinecraftArgumentTypes.registerResourceOrTag(argumentRegistry, BiomeResourceOrTag.class, () -> Registries.BIOME, (ctx, name) -> new BiomeResourceOrTag((ResourceOrTagArgument.Result<Biome>)ResourceOrTagArgument.getResourceOrTag((CommandContext)ctx, (String)name, (ResourceKey)Registries.BIOME)));
        MinecraftArgumentTypes.registerResourceOrTag(argumentRegistry, PoiTypeResourceOrTag.class, () -> Registries.POINT_OF_INTEREST_TYPE, (ctx, name) -> new PoiTypeResourceOrTag((ResourceOrTagArgument.Result<PoiType>)ResourceOrTagArgument.getResourceOrTag((CommandContext)ctx, (String)name, (ResourceKey)Registries.POINT_OF_INTEREST_TYPE)));
        MinecraftArgumentTypes.registerResourceOrTagKey(argumentRegistry, StructureResourceOrTagKey.class, () -> Registries.STRUCTURE, (ctx, name) -> new StructureResourceOrTagKey((ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)name, (ResourceKey)Registries.STRUCTURE, (DynamicCommandExceptionType)DynamicExceptionTypes.ERROR_STRUCTURE_INVALID)));
    }

    private static <T extends ResourceOrTagBase<R>, R> void registerResourceOrTag(ArgumentTypeRegistryImpl argumentRegistry, Class<T> clazz, Supplier<ResourceKey<Registry<R>>> registrySupplier, CommandBiFunction<CommandContext<CommandSourceStack>, String, T> referenceSupplier) {
        argumentRegistry.register(clazz, ctx -> ResourceOrTagArgument.resourceOrTag((CommandBuildContext)ctx, (ResourceKey)((ResourceKey)registrySupplier.get())), (context, name, value) -> value == null ? null : referenceSupplier.apply(context, name));
    }

    private static <T extends ResourceOrTagKeyBase<R>, R> void registerResourceOrTagKey(ArgumentTypeRegistryImpl argumentRegistry, Class<T> clazz, Supplier<ResourceKey<Registry<R>>> registrySupplier, CommandBiFunction<CommandContext<CommandSourceStack>, String, T> referenceSupplier) {
        argumentRegistry.register(clazz, ctx -> ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)((ResourceKey)registrySupplier.get())), (context, name, value) -> value == null ? null : referenceSupplier.apply(context, name));
    }

    private static <T extends ReferenceBase<R>, R> void registerResourceReference(ArgumentTypeRegistryImpl argumentRegistry, Class<T> clazz, Supplier<ResourceKey<Registry<R>>> registrySupplier, CommandBiFunction<CommandContext<CommandSourceStack>, String, T> referenceSupplier) {
        argumentRegistry.register(clazz, ctx -> ResourceArgument.resource((CommandBuildContext)ctx, (ResourceKey)((ResourceKey)registrySupplier.get())), (context, name, value) -> value == null ? null : referenceSupplier.apply(context, name));
    }

    private static <T extends ReferenceBase<R>, R> void registerResourceKeyReference(ArgumentTypeRegistryImpl argumentRegistry, Class<T> clazz, Supplier<ResourceKey<Registry<R>>> registrySupplier, CommandBiFunction<CommandContext<CommandSourceStack>, String, T> referenceSupplier) {
        argumentRegistry.register(clazz, ctx -> ResourceKeyArgument.key((ResourceKey)((ResourceKey)registrySupplier.get())), (context, name, value) -> value == null ? null : referenceSupplier.apply(context, name));
    }
}

