/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl.permissions;

import de.maxhenkel.admiral.annotations.RequiresPermission;
import de.maxhenkel.admiral.annotations.RequiresPermissionLevel;
import de.maxhenkel.admiral.impl.permissions.Permission;
import de.maxhenkel.admiral.impl.permissions.PermissionLevel;
import de.maxhenkel.admiral.impl.permissions.PermissionNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class PermissionAnnotationUtil {
    public static <S> List<Permission<S>> getPermissions(Class<?> clazz) {
        return PermissionAnnotationUtil.getPermission(Arrays.asList((RequiresPermission[])clazz.getDeclaredAnnotationsByType(RequiresPermission.class)), clazz.getDeclaredAnnotation(RequiresPermissionLevel.class));
    }

    public static <S> List<Permission<S>> getPermissions(Method method) {
        return PermissionAnnotationUtil.getPermission(Arrays.asList((RequiresPermission[])method.getDeclaredAnnotationsByType(RequiresPermission.class)), method.getDeclaredAnnotation(RequiresPermissionLevel.class));
    }

    private static <S> List<Permission<S>> getPermission(List<RequiresPermission> requiredPermissions, @Nullable RequiresPermissionLevel requiredPermissionLevel) {
        ArrayList<Permission<S>> permissions = new ArrayList<Permission<S>>();
        for (RequiresPermission requiredPermission : requiredPermissions) {
            permissions.add(new PermissionNode(requiredPermission.value()));
        }
        if (requiredPermissionLevel != null) {
            permissions.add(new PermissionLevel(requiredPermissionLevel.value()));
        }
        return permissions;
    }
}

