/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeRegistry;
import de.maxhenkel.admiral.impl.AdmiralImpl;
import de.maxhenkel.admiral.impl.ArgumentTypeRegistryImpl;
import de.maxhenkel.admiral.permissions.PermissionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class Admiral<S, C> {
    public static <S, C> Builder<S, C> builder(CommandDispatcher<S> dispatcher) {
        return AdmiralImpl.builder(dispatcher, null);
    }

    public static abstract class Builder<S, C> {
        protected final CommandDispatcher<S> dispatcher;
        @Nullable
        protected final C commandBuildContext;
        protected final ArgumentTypeRegistryImpl argumentRegistry;
        protected final List<Class<?>> classes;
        @Nullable
        protected PermissionManager<S> permissionManager;

        protected Builder(CommandDispatcher<S> dispatcher, @Nullable C commandBuildContext) {
            this.dispatcher = dispatcher;
            this.commandBuildContext = commandBuildContext;
            this.argumentRegistry = new ArgumentTypeRegistryImpl();
            this.classes = new ArrayList();
        }

        public Builder<S, C> addCommandClasses(Collection<Class<?>> classCollection) {
            this.classes.addAll(classCollection);
            return this;
        }

        public Builder<S, C> addCommandClasses(Class<?> ... classArray) {
            this.classes.addAll(Arrays.asList(classArray));
            return this;
        }

        public Builder<S, C> addArgumentTypes(Consumer<ArgumentTypeRegistry> argumentRegistryConsumer) {
            argumentRegistryConsumer.accept(this.argumentRegistry);
            return this;
        }

        public Builder<S, C> setPermissionManager(PermissionManager<S> permissionManager) {
            this.permissionManager = permissionManager;
            return this;
        }

        public abstract Admiral<S, C> build();
    }
}

