/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeConverter;
import de.maxhenkel.admiral.argumenttype.ArgumentTypeSupplier;
import de.maxhenkel.admiral.argumenttype.RangedArgumentTypeSupplier;
import de.maxhenkel.admiral.impl.AdmiralImpl;
import de.maxhenkel.admiral.impl.AdmiralParameter;
import de.maxhenkel.admiral.impl.ArgumentTypeRegistryImpl;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class AdmiralArgumentType<S, C, A, T> {
    private AdmiralParameter<S, C, A, T> admiralParameter;
    private Class<T> parameterClass;
    private ArgumentTypeSupplier<S, C, A> argumentType;
    private Class<A> argumentTypeClass;
    @Nullable
    private ArgumentTypeConverter<S, A, T> converter;

    private AdmiralArgumentType() {
    }

    public static <S, C, A, T> AdmiralArgumentType<S, C, A, T> fromClass(AdmiralParameter<S, C, A, T> admiralParameter, Class<T> parameterClass) {
        ArgumentTypeRegistryImpl registry = admiralParameter.getAdmiral().getArgumentRegistry();
        ArgumentTypeSupplier argumentTypeSupplier = registry.getType(parameterClass);
        if (argumentTypeSupplier == null) {
            throw new IllegalStateException(String.format("ArgumentType %s not registered", parameterClass.getSimpleName()));
        }
        AdmiralArgumentType<S, C, A, T> argumentType = new AdmiralArgumentType<S, C, A, T>();
        argumentType.admiralParameter = admiralParameter;
        argumentType.parameterClass = parameterClass;
        argumentType.argumentType = argumentTypeSupplier;
        argumentType.argumentTypeClass = AdmiralArgumentType.getArgumentTypeClass(argumentType.argumentType.get(admiralParameter.getAdmiral().getCommandBuildContext()));
        argumentType.converter = registry.getConverter(parameterClass);
        return argumentType;
    }

    public Class<T> getParameterClass() {
        return this.parameterClass;
    }

    public Class<A> getArgumentTypeClass() {
        return this.argumentTypeClass;
    }

    public AdmiralImpl<S, C> getAdmiral() {
        return this.admiralParameter.getAdmiral();
    }

    public ArgumentType<A> getArgumentType(@Nullable A min, @Nullable A max) {
        if (this.argumentType instanceof RangedArgumentTypeSupplier) {
            return ((RangedArgumentTypeSupplier)this.argumentType).getRanged(this.getAdmiral().getCommandBuildContext(), min, max);
        }
        return this.argumentType.get(this.getAdmiral().getCommandBuildContext());
    }

    public SuggestionProvider<S> getSuggestionProvider() {
        return this.argumentType.getSuggestionProvider();
    }

    @Nullable
    public Object convert(CommandContext<S> context, @Nullable A argumentTypeValue) throws CommandSyntaxException {
        if (argumentTypeValue == null && this.parameterClass.isPrimitive()) {
            return AdmiralArgumentType.defaultValue(this.parameterClass);
        }
        if (this.converter != null) {
            return this.converter.convertRaw(context, this.admiralParameter.getName(), argumentTypeValue);
        }
        return argumentTypeValue;
    }

    public static Object defaultValue(Class<?> type) {
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        throw new IllegalStateException(String.format("Could not find default value for %s", type.getSimpleName()));
    }

    public static <T extends ArgumentType<A>, A> Class<A> getArgumentTypeClass(T argumentType) {
        try {
            Method parse = argumentType.getClass().getMethod("parse", StringReader.class);
            parse.setAccessible(true);
            return parse.getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

