/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.admiral.impl;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.admiral.annotations.Command;
import de.maxhenkel.admiral.impl.AdmiralClass;
import de.maxhenkel.admiral.impl.AdmiralImpl;
import de.maxhenkel.admiral.impl.AdmiralParameter;
import de.maxhenkel.admiral.impl.ExceptionUtils;
import de.maxhenkel.admiral.impl.Log;
import de.maxhenkel.admiral.impl.MethodParameter;
import de.maxhenkel.admiral.impl.permissions.Permission;
import de.maxhenkel.admiral.impl.permissions.PermissionAnnotationUtil;
import de.maxhenkel.admiral.permissions.PermissionManager;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AdmiralMethod<S, C> {
    private final AdmiralClass<S, C> admiralClass;
    private final Method method;
    private List<MethodParameter<S, C, ?, ?>> parameters;
    private List<Command> commands;
    private List<Permission<S>> requiredPermissions;

    public AdmiralMethod(AdmiralClass<S, C> admiralClass, Method method) {
        this.admiralClass = admiralClass;
        this.method = method;
        this.parameters = new ArrayList();
        this.commands = new ArrayList<Command>();
        this.requiredPermissions = new ArrayList<Permission<S>>();
    }

    public List<WrappedArgumentBuilder<S>> register() {
        this.parameters = this.collectParameters();
        this.commands = Arrays.asList((Command[])this.method.getDeclaredAnnotationsByType(Command.class));
        this.requiredPermissions = PermissionAnnotationUtil.getPermissions(this.method);
        ArrayList<WrappedArgumentBuilder<S>> nodes = new ArrayList<WrappedArgumentBuilder<S>>();
        for (List<String> path : this.getPaths()) {
            nodes.add(this.handleCommand(path));
        }
        return nodes;
    }

    private WrappedArgumentBuilder<S> handleCommand(List<String> path) {
        RequiredArgumentBuilder<S, ?> last = null;
        AdmiralParameter<S, C, ?, ?> lastParameter = null;
        for (int i = this.parameters.size() - 1; i >= 0; --i) {
            MethodParameter<S, C, ?, ?> methodParameter = this.parameters.get(i);
            if (methodParameter.getAdmiralParameter() == null) continue;
            AdmiralParameter<S, C, ?, ?> admiralParameter = methodParameter.getAdmiralParameter();
            RequiredArgumentBuilder<S, ?> argument = admiralParameter.toArgument();
            if (last != null) {
                argument.then(last);
            }
            this.permission(null, (ArgumentBuilder<S, ?>)argument);
            if (lastParameter == null || lastParameter.isOptional()) {
                this.execute((ArgumentBuilder<S, ?>)argument);
            }
            last = argument;
            lastParameter = admiralParameter;
        }
        boolean firstPass = true;
        for (int i = path.size() - 1; i >= 0; --i) {
            RequiredArgumentBuilder<S, ?> literal = LiteralArgumentBuilder.literal((String)path.get(i));
            if (last != null) {
                literal.then(last);
            }
            this.permission(path, (ArgumentBuilder<S, ?>)literal);
            if ((lastParameter == null || lastParameter.isOptional()) && firstPass) {
                this.execute((ArgumentBuilder<S, ?>)literal);
            }
            last = literal;
            firstPass = false;
        }
        return new WrappedArgumentBuilder(last, (lastParameter == null || lastParameter.isOptional()) && firstPass);
    }

    protected void execute(ArgumentBuilder<S, ?> builder) {
        builder.executes(this::onExecute);
    }

    private void permission(List<String> path, ArgumentBuilder<S, ?> builder) {
        if (path == null) {
            builder.requires(source -> {
                PermissionManager permissionManager = this.getAdmiral().getPermissionManager();
                if (!this.admiralClass.checkClassPermissions(source, permissionManager)) {
                    return false;
                }
                return this.requiredPermissions.stream().allMatch(p -> p.hasPermission(source, permissionManager));
            });
            return;
        }
        List<List<Permission<S>>> perms = this.getAllRequiredPermissions(path);
        perms.add(this.requiredPermissions);
        builder.requires(source -> {
            PermissionManager permissionManager = this.getAdmiral().getPermissionManager();
            if (!this.admiralClass.checkClassPermissions(source, permissionManager)) {
                return false;
            }
            return perms.stream().anyMatch(permissions -> permissions.stream().allMatch(p -> p.hasPermission(source, permissionManager)));
        });
    }

    private List<List<Permission<S>>> getAllRequiredPermissions(List<String> path) {
        return this.admiralClass.getPermissions().computeIfAbsent(String.join((CharSequence)"/", path), k -> new ArrayList());
    }

    private int onExecute(CommandContext<S> context) throws CommandSyntaxException {
        try {
            Object[] args = new Object[this.parameters.size()];
            for (int i = 0; i < this.parameters.size(); ++i) {
                MethodParameter<S, C, ?, ?> methodParameter = this.parameters.get(i);
                Parameter parameter = methodParameter.getParameter();
                AdmiralParameter<S, C, ?, ?> admiralParameter = methodParameter.getAdmiralParameter();
                if (admiralParameter == null) {
                    if (parameter.getType().isAssignableFrom(CommandContext.class)) {
                        args[i] = context;
                        continue;
                    }
                    throw new IllegalArgumentException(String.format("Invalid parameter type: %s", parameter.getType().getSimpleName()));
                }
                args[i] = admiralParameter.getValue(context);
            }
            Object result = this.method.invoke(this.admiralClass.getInstance(), args);
            if (result instanceof Integer) {
                return (Integer)result;
            }
            return 1;
        }
        catch (Exception e) {
            Log.LOGGER.log(Level.SEVERE, "Error while executing command", e);
            throw ExceptionUtils.getAsCommandSyntaxException(e);
        }
    }

    private List<MethodParameter<S, C, ?, ?>> collectParameters() {
        List<Parameter> list = Arrays.asList(this.method.getParameters());
        ArrayList parameters = new ArrayList(list.size());
        boolean wasOptional = false;
        for (Parameter parameter : list) {
            if (parameter.getType().isAssignableFrom(CommandContext.class)) {
                parameters.add(new MethodParameter(parameter));
                continue;
            }
            AdmiralParameter admiralParameter = new AdmiralParameter(this, parameter);
            parameters.add(new MethodParameter(parameter, admiralParameter));
            if (!admiralParameter.isOptional() && wasOptional) {
                throw new IllegalStateException("Optional parameters must be at the end of the parameter list");
            }
            wasOptional = admiralParameter.isOptional();
        }
        return parameters;
    }

    private List<List<String>> getPaths() {
        return this.commands.stream().map(command -> new ArrayList<String>(Arrays.asList(command.value()))).collect(Collectors.toList());
    }

    public AdmiralClass<S, C> getAdmiralClass() {
        return this.admiralClass;
    }

    public AdmiralImpl<S, C> getAdmiral() {
        return this.admiralClass.getAdmiral();
    }

    public static class WrappedArgumentBuilder<S> {
        @Nullable
        public final ArgumentBuilder<S, ?> builder;
        public final boolean needsExecution;

        public WrappedArgumentBuilder(ArgumentBuilder<S, ?> builder, boolean needsExecution) {
            this.builder = builder;
            this.needsExecution = needsExecution;
        }
    }
}

