/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class BeeHousingModifier {
    private final EnumTolerance temperatureMod;
    private final EnumTolerance humidityMod;
    private final float lifespanMod;
    private final float productivityMod;
    private final float territoryMod;
    private final float mutationMod;
    private final boolean skyOverride;
    private final boolean rainOverride;
    private final boolean sleepOverride;

    public static BeeHousingModifier of(BeeHousingModifier ... modifiers) {
        EnumTolerance temperatureMod = EnumTolerance.NONE;
        EnumTolerance humidityMod = EnumTolerance.NONE;
        float lifespanMod = 1.0f;
        float productivityMod = 1.0f;
        float territoryMod = 1.0f;
        float mutationMod = 1.0f;
        boolean skyOverride = false;
        boolean rainOverride = false;
        boolean sleepOverride = false;
        for (BeeHousingModifier modifier : modifiers) {
            temperatureMod = EnumTolerance.getFromCollapsed(temperatureMod.collapsed() + modifier.temperatureMod.collapsed());
            humidityMod = EnumTolerance.getFromCollapsed(humidityMod.collapsed() + modifier.humidityMod.collapsed());
            lifespanMod *= modifier.lifespanMod;
            productivityMod *= modifier.productivityMod;
            territoryMod *= modifier.territoryMod;
            mutationMod *= modifier.mutationMod;
            skyOverride = skyOverride || modifier.skyOverride;
            rainOverride = rainOverride || modifier.rainOverride;
            sleepOverride = sleepOverride || modifier.sleepOverride;
        }
        return new BeeHousingModifier(temperatureMod, humidityMod, lifespanMod, productivityMod, territoryMod, mutationMod, skyOverride, rainOverride, sleepOverride);
    }

    public BeeHousingModifier(EnumTolerance temperatureMod, EnumTolerance humidityMod, float lifespanMod, float productivityMod, float territoryMod, float mutationMod, boolean skyOverride, boolean rainOverride, boolean sleepOverride) {
        this.temperatureMod = temperatureMod;
        this.humidityMod = humidityMod;
        this.lifespanMod = lifespanMod;
        this.productivityMod = productivityMod;
        this.territoryMod = territoryMod;
        this.mutationMod = mutationMod;
        this.skyOverride = skyOverride;
        this.rainOverride = rainOverride;
        this.sleepOverride = sleepOverride;
    }

    public BeeHousingModifier() {
        this(EnumTolerance.NONE, EnumTolerance.NONE, 1.0f, 1.0f, 1.0f, 1.0f, false, false, false);
    }

    public EnumTolerance getTemperatureMod() {
        return this.temperatureMod;
    }

    public EnumTolerance getHumidityMod() {
        return this.humidityMod;
    }

    public float getLifespanMod() {
        return this.lifespanMod;
    }

    public float getProductivityMod() {
        return this.productivityMod;
    }

    public float getTerritoryMod() {
        return this.territoryMod;
    }

    public float getMutationMod() {
        return this.mutationMod;
    }

    public boolean getSkyOverride() {
        return this.skyOverride;
    }

    public boolean getRainOverride() {
        return this.rainOverride;
    }

    public boolean getSleepOverride() {
        return this.sleepOverride;
    }

    public List<Component> getTooltipComponent() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (Minecraft.m_91087_().f_91073_ != null) {
            if (this.getLifespanMod() != 1.0f) {
                components.add((Component)Component.m_237115_((String)"gene.complicated_bees.lifespan_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(this.getLifespanMod() + "x"))).m_130940_(ChatFormatting.GRAY));
            }
            if (this.getProductivityMod() != 1.0f) {
                components.add((Component)Component.m_237115_((String)"gene.complicated_bees.productivity_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(this.getProductivityMod() + "x"))).m_130940_(ChatFormatting.GRAY));
            }
            if (!this.getTemperatureMod().equals((Object)EnumTolerance.NONE)) {
                components.add((Component)Component.m_237115_((String)"gene.complicated_bees.temperature_label").m_130946_(": ").m_7220_(this.getTemperatureMod().getTranslationKey()).m_130940_(ChatFormatting.GRAY));
            }
            if (!this.getHumidityMod().equals((Object)EnumTolerance.NONE)) {
                components.add((Component)Component.m_237115_((String)"gene.complicated_bees.humidity_label").m_130946_(": ").m_7220_(this.getHumidityMod().getTranslationKey()).m_130940_(ChatFormatting.GRAY));
            }
            if (this.getTerritoryMod() != 1.0f) {
                components.add((Component)Component.m_237115_((String)"gene.complicated_bees.territory_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(this.getTerritoryMod() + "x"))).m_130940_(ChatFormatting.GRAY));
            }
            if (this.getMutationMod() != 1.0f) {
                components.add((Component)Component.m_237115_((String)"gui.complicated_bees.jei.mutations").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(this.getMutationMod() + "x"))).m_130940_(ChatFormatting.GRAY));
            }
            if (this.getSleepOverride()) {
                components.add((Component)Component.m_237115_((String)"frame.complicated_bees.overrides_sleep").m_130940_(ChatFormatting.GRAY));
            }
            if (this.getSkyOverride()) {
                components.add((Component)Component.m_237115_((String)"frame.complicated_bees.overrides_sky").m_130940_(ChatFormatting.GRAY));
            }
            if (this.getRainOverride()) {
                components.add((Component)Component.m_237115_((String)"frame.complicated_bees.overrides_rain").m_130940_(ChatFormatting.GRAY));
            }
        }
        return components;
    }

    public static class Builder {
        private EnumTolerance temperatureMod = EnumTolerance.NONE;
        private EnumTolerance humidityMod = EnumTolerance.NONE;
        private float lifespanMod = 1.0f;
        private float productivityMod = 1.0f;
        private float territoryMod = 1.0f;
        private float mutationMod = 1.0f;
        private boolean skyOverride = false;
        private boolean rainOverride = false;
        private boolean sleepOverride = false;

        public BeeHousingModifier build() {
            return new BeeHousingModifier(this.temperatureMod, this.humidityMod, this.lifespanMod, this.productivityMod, this.territoryMod, this.mutationMod, this.skyOverride, this.rainOverride, this.sleepOverride);
        }

        public Builder temperature(EnumTolerance mod) {
            this.temperatureMod = mod;
            return this;
        }

        public Builder humidity(EnumTolerance mod) {
            this.humidityMod = mod;
            return this;
        }

        public Builder lifespan(float mod) {
            this.lifespanMod = mod;
            return this;
        }

        public Builder productivity(float mod) {
            this.productivityMod = mod;
            return this;
        }

        public Builder territory(float mod) {
            this.territoryMod = mod;
            return this;
        }

        public Builder mutation(float mod) {
            this.mutationMod = mod;
            return this;
        }

        public Builder skyOverride(boolean value) {
            this.skyOverride = value;
            return this;
        }

        public Builder rainOverride(boolean value) {
            this.rainOverride = value;
            return this;
        }

        public Builder sleepOverride(boolean value) {
            this.sleepOverride = value;
            return this;
        }
    }
}

