/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.IGene;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class Chromosome {
    private Map<ResourceLocation, IGene<?>> genes;

    public Chromosome() {
        this.genes = new HashMap();
        if (ComplicatedBees.GENE_REGISTRY.get() != null) {
            for (Map.Entry entry : ComplicatedBees.GENE_REGISTRY.get().getEntries()) {
                this.genes.put(((ResourceKey)entry.getKey()).m_135782_(), (IGene)ComplicatedBees.GENE_REGISTRY.get().getValue(((ResourceKey)entry.getKey()).m_135782_()));
            }
        }
    }

    public Chromosome(CompoundTag genomeAsTag) {
        this.genes = new HashMap();
        for (Map.Entry entry : ComplicatedBees.GENE_REGISTRY.get().getEntries()) {
            ResourceLocation geneLocation = ((ResourceKey)entry.getKey()).m_135782_();
            if (genomeAsTag.m_128441_(geneLocation.toString())) {
                CompoundTag serializedGene = genomeAsTag.m_128469_(geneLocation.toString());
                if (!serializedGene.m_128441_("dominant")) {
                    serializedGene.m_128379_("dominant", true);
                }
                this.genes.put(geneLocation, ((IGene)entry.getValue()).deserialize(serializedGene));
                continue;
            }
            this.genes.put(((ResourceKey)entry.getKey()).m_135782_(), (IGene)ComplicatedBees.GENE_REGISTRY.get().getValue(((ResourceKey)entry.getKey()).m_135782_()));
        }
    }

    public Chromosome(Species species) {
        this.genes = species.getDefaultChromosome().getGenes();
    }

    public Chromosome(Map<ResourceLocation, IGene<?>> genes) {
        this.genes = genes;
    }

    public Map<ResourceLocation, IGene<?>> getGenes() {
        return this.genes;
    }

    public Chromosome copy() {
        return new Chromosome(this.serialize());
    }

    public Chromosome setGenes(Map<ResourceLocation, IGene<?>> genes) {
        this.genes = genes;
        return this;
    }

    public IGene<?> getGene(ResourceLocation id) {
        return this.genes.getOrDefault(id, (IGene)ComplicatedBees.GENE_REGISTRY.get().getValue(id));
    }

    public Chromosome setGene(ResourceLocation id, IGene<?> gene) {
        this.genes.put(id, gene);
        return this;
    }

    public Chromosome removeGene(ResourceLocation id) {
        this.genes.remove(id);
        return this;
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        Map<ResourceLocation, IGene<?>> genes = this.getGenes();
        for (ResourceLocation key : genes.keySet()) {
            tag.m_128365_(key.toString(), (Tag)genes.get(key).serialize());
        }
        return tag;
    }

    public static Chromosome deserialize(CompoundTag tag) {
        HashMap genes = new HashMap();
        for (Map.Entry entry : ComplicatedBees.GENE_REGISTRY.get().getEntries()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            CompoundTag geneData = tag.m_128469_(id.toString());
            if (geneData.equals((Object)new CompoundTag())) continue;
            if (!geneData.m_128441_("dominant")) {
                geneData.m_128379_("dominant", true);
            }
            genes.put(id, Objects.requireNonNull((IGene)ComplicatedBees.GENE_REGISTRY.get().getValue(id)).deserialize(geneData));
        }
        return new Chromosome(genes);
    }
}

