/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class Flower {
    private final Set<Block> flowerBlocks;
    private final Set<TagKey<Block>> flowerTags;
    public static final Flower INVALID = new Flower(new ArrayList<ResourceLocation>(), new ArrayList<TagKey<Block>>());

    private Flower(Set<Block> flowerBlocks, Set<TagKey<Block>> flowerTags) {
        this.flowerBlocks = flowerBlocks;
        this.flowerTags = flowerTags;
    }

    public Flower(List<ResourceLocation> blocks, List<TagKey<Block>> tags) {
        this.flowerBlocks = new HashSet<Block>();
        this.flowerTags = new HashSet<TagKey<Block>>();
        for (ResourceLocation block : blocks) {
            this.flowerBlocks.add((Block)ForgeRegistries.BLOCKS.getValue(block));
        }
        this.flowerTags.addAll(tags);
    }

    public Flower copy() {
        return new Flower(this.flowerBlocks, this.flowerTags);
    }

    public boolean isAcceptable(BlockState block) {
        return this.flowerBlocks.contains(block.m_60734_()) || this.withinTags(block);
    }

    private boolean withinTags(BlockState block) {
        boolean within = false;
        for (TagKey<Block> blockTagKey : this.flowerTags) {
            within = block.m_204336_(blockTagKey) || within;
        }
        return within;
    }

    public List<ResourceLocation> getBlocksAsResourceLocs() {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (Block block : this.flowerBlocks) {
            result.add(ForgeRegistries.BLOCKS.getKey((Object)block));
        }
        return result;
    }

    public Set<Block> getAllFlowerBlocks() {
        HashSet<Block> blocks = new HashSet<Block>(this.flowerBlocks);
        this.getFlowerTags().forEach(tagKey -> ForgeRegistries.BLOCKS.tags().getTag(tagKey).forEach(blocks::add));
        return blocks;
    }

    public Set<TagKey<Block>> getFlowerTags() {
        return this.flowerTags;
    }
}

