/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.accbdd.complicated_bees.bees.Chromosome;
import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.Genome;
import com.accbdd.complicated_bees.bees.IBeeHousing;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.gene.GeneSpecies;
import com.accbdd.complicated_bees.bees.gene.GeneTolerant;
import com.accbdd.complicated_bees.bees.gene.IGene;
import com.accbdd.complicated_bees.bees.gene.enums.EnumTolerance;
import com.accbdd.complicated_bees.bees.mutation.Mutation;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.bees.tracking.BreedingTracker;
import com.accbdd.complicated_bees.config.ServerConfig;
import com.accbdd.complicated_bees.item.BeeItem;
import com.accbdd.complicated_bees.item.PrincessItem;
import com.accbdd.complicated_bees.item.QueenItem;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.MutationRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.server.ServerLifecycleHooks;

public class GeneticHelper {
    public static final String CHROMOSOME_A = "chromosome_a";
    public static final String CHROMOSOME_B = "chromosome_b";
    public static final String SPECIES = "species";
    public static final String MATE = "mate";
    private static final Random rand = new Random();

    public static Chromosome getChromosome(ItemStack stack, boolean primary) {
        CompoundTag serializedGenome = stack.m_41784_().m_128469_(primary ? CHROMOSOME_A : CHROMOSOME_B);
        return Chromosome.deserialize(serializedGenome);
    }

    public static Genome getGenome(ItemStack stack) {
        CompoundTag genome_a = stack.m_41784_().m_128469_(CHROMOSOME_A);
        CompoundTag genome_b = stack.m_41784_().m_128469_(CHROMOSOME_B);
        return new Genome(Chromosome.deserialize(genome_a), Chromosome.deserialize(genome_b));
    }

    public static ItemStack setGenome(ItemStack stack, Chromosome chromosome, boolean primary) {
        stack.m_41784_().m_128365_(primary ? CHROMOSOME_A : CHROMOSOME_B, (Tag)chromosome.serialize());
        return stack;
    }

    public static ItemStack setGenome(ItemStack stack, Genome genome) {
        stack.m_41784_().m_128365_(CHROMOSOME_A, (Tag)genome.getPrimary().serialize());
        stack.m_41784_().m_128365_(CHROMOSOME_B, (Tag)genome.getSecondary().serialize());
        GeneticHelper.setSpeciesTag(stack);
        return stack;
    }

    public static ItemStack setGenome(ItemStack stack, Chromosome chromosome) {
        GeneticHelper.setGenome(stack, new Genome(chromosome));
        return stack;
    }

    public static void setMate(ItemStack stack, Genome genome) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(CHROMOSOME_A, (Tag)genome.getPrimary().serialize());
        tag.m_128365_(CHROMOSOME_B, (Tag)genome.getSecondary().serialize());
        stack.m_41784_().m_128365_(MATE, (Tag)tag);
    }

    public static RegistryAccess getRegistryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            if (FMLEnvironment.dist.equals((Object)Dist.DEDICATED_SERVER) || Minecraft.m_91087_() == null) {
                return null;
            }
            if (Minecraft.m_91087_().m_91403_() == null) {
                return null;
            }
            return Minecraft.m_91087_().m_91403_().m_105152_();
        }
        return ServerLifecycleHooks.getCurrentServer().m_206579_();
    }

    public static MutableComponent getTranslationKey(Species species) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        return Component.m_237115_((String)("species.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species))));
    }

    public static MutableComponent getGenusTaxonomyKey(Species species) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        MutableComponent mutableComponent = Component.m_264568_((String)("species.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species)) + ".genus"), (String)"null");
        return mutableComponent.getString().equals("null") ? Component.m_237115_((String)"gui.complicated_bees.no_genus") : mutableComponent;
    }

    public static MutableComponent getSpeciesTaxonomyKey(Species species) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        MutableComponent mutableComponent = Component.m_264568_((String)("species.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species)) + ".species_taxonomy"), (String)"null");
        return mutableComponent.getString().equals("null") ? Component.m_237115_((String)"gui.complicated_bees.no_species") : mutableComponent;
    }

    public static MutableComponent getFlavorTextKey(Species species) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        MutableComponent mutableComponent = Component.m_264568_((String)("species.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species)) + ".flavor_text"), (String)"null");
        return mutableComponent.getString().equals("null") ? Component.m_237115_((String)"gui.complicated_bees.no_flavor") : mutableComponent;
    }

    public static MutableComponent getFlavorTextAuthorKey(Species species) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        MutableComponent mutableComponent = Component.m_264568_((String)("species.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species)) + ".flavor_author"), (String)"null");
        return mutableComponent.getString().equals("null") ? Component.m_237115_((String)"gui.complicated_bees.no_author") : mutableComponent;
    }

    public static MutableComponent getAuthorityKey(Species species) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        MutableComponent mutableComponent = Component.m_264568_((String)("species.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(SpeciesRegistration.SPECIES_REGISTRY_KEY).get()).m_7981_((Object)species)) + ".authority"), (String)"null");
        return mutableComponent.getString().equals("null") ? Component.m_237115_((String)"gui.complicated_bees.no_authority") : mutableComponent;
    }

    public static MutableComponent getTranslationKey(Flower flower) {
        RegistryAccess registryAccess = GeneticHelper.getRegistryAccess();
        return Component.m_237115_((String)("flower.complicated_bees." + String.valueOf(((Registry)registryAccess.m_6632_(FlowerRegistration.FLOWER_REGISTRY_KEY).get()).m_7981_((Object)flower))));
    }

    public static MutableComponent getSpeciesHybridName(ItemStack stack) {
        Species secondary;
        Species primary;
        if (stack.m_41720_() instanceof BeeItem && !(primary = GeneticHelper.getSpecies(stack, true)).equals(secondary = GeneticHelper.getSpecies(stack, false))) {
            MutableComponent name = Component.m_237119_();
            name.m_7220_((Component)GeneticHelper.getTranslationKey(primary));
            name.m_130946_("-").m_7220_((Component)GeneticHelper.getTranslationKey(secondary));
            name.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gene.complicated_bees.hybrid"));
            return name;
        }
        return null;
    }

    public static void setSpeciesTag(ItemStack stack) {
        Species species = GeneticHelper.getSpecies(stack, true);
        stack.m_41784_().m_128359_(SPECIES, SpeciesRegistration.getResourceLocation(species).toString());
    }

    public static CompoundTag getRaw(ItemStack stack, ResourceLocation id, boolean primary) {
        CompoundTag chromosomeTag;
        if (stack.m_41782_() & stack.m_41783_() != null && (chromosomeTag = stack.m_41783_().m_128469_(primary ? CHROMOSOME_A : CHROMOSOME_B)).m_128441_(id.toString())) {
            return chromosomeTag.m_128469_(id.toString());
        }
        return new CompoundTag();
    }

    public static IGene<?> getGene(ItemStack stack, ResourceLocation id, boolean primary) {
        return GeneticHelper.getChromosome(stack, primary).getGene(id);
    }

    public static Species getSpecies(ItemStack stack, boolean primary) {
        Species species = (Species)GeneticHelper.getGene(stack, GeneSpecies.ID, primary).get();
        return species == null ? Species.INVALID : species;
    }

    public static ResourceLocation getSpeciesLoc(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(SPECIES)) {
            return ResourceLocation.m_135820_((String)stack.m_41783_().m_128461_(SPECIES));
        }
        return null;
    }

    public static Object getGeneValue(ItemStack stack, ResourceLocation id, boolean primary) {
        return GeneticHelper.getGene(stack, id, primary).get();
    }

    private static Genome mixGenomes(Genome left, Genome right, Level level, BlockPos pos, float ... mutationModifiers) {
        IBeeHousing housing;
        Chromosome chromosome_a = new Chromosome();
        Chromosome chromosome_b = new Chromosome();
        float mutationChanceMod = 1.0f;
        for (float f : mutationModifiers) {
            mutationChanceMod *= f;
        }
        ArrayList<Mutation> possibleMutations = new ArrayList<Mutation>();
        BreedingTracker tracker = null;
        BlockEntity f = level.m_7702_(pos);
        if (f instanceof IBeeHousing && (housing = (IBeeHousing)f).getOwner() != null) {
            tracker = BreedingTracker.getTracker(housing.getOwner());
        }
        for (Map.Entry<ResourceLocation, IGene<?>> geneEntry : chromosome_a.getGenes().entrySet()) {
            ResourceLocation key = geneEntry.getKey();
            IGene<?> geneA = ((double)rand.nextFloat() < 0.5 ? left.getPrimary() : left.getSecondary()).getGene(key);
            IGene<?> geneB = ((double)rand.nextFloat() < 0.5 ? right.getPrimary() : right.getSecondary()).getGene(key);
            if (geneEntry.getValue() instanceof GeneTolerant) {
                EnumTolerance toleranceA = ((GeneTolerant)((double)rand.nextFloat() < 0.5 ? left.getPrimary() : left.getSecondary()).getGene(key)).getTolerance();
                EnumTolerance toleranceB = ((GeneTolerant)((double)rand.nextFloat() < 0.5 ? right.getPrimary() : right.getSecondary()).getGene(key)).getTolerance();
                geneA = ((GeneTolerant)geneA).setTolerance(toleranceA);
                geneB = ((GeneTolerant)geneB).setTolerance(toleranceB);
            } else if (geneEntry.getValue() instanceof GeneSpecies) {
                Species speciesA = (Species)geneA.get();
                Species speciesB = (Species)geneB.get();
                for (Mutation mutation : ((Registry)ServerLifecycleHooks.getCurrentServer().m_206579_().m_6632_(MutationRegistration.MUTATION_REGISTRY_KEY).get()).m_123024_().toList()) {
                    if ((mutation.getFirstSpecies() != speciesA || mutation.getSecondSpecies() != speciesB) && (mutation.getSecondSpecies() != speciesA || mutation.getFirstSpecies() != speciesB)) continue;
                    boolean canMutate = true;
                    for (IMutationCondition condition : mutation.getConditions()) {
                        canMutate = canMutate && condition.check(level, pos);
                    }
                    if (!canMutate) continue;
                    float mod = 0.0f;
                    if (tracker != null && tracker.isResearched(mutation)) {
                        mod = ((Float)ServerConfig.SERVER_CONFIG.researchBonus.get()).floatValue();
                    }
                    if (!(rand.nextFloat() < mutation.getChance() * mutationChanceMod + mod)) continue;
                    possibleMutations.add(mutation);
                }
            }
            chromosome_a.setGene(key, geneA);
            chromosome_b.setGene(key, geneB);
        }
        if (!possibleMutations.isEmpty()) {
            boolean doubleMutate;
            Mutation selected = (Mutation)possibleMutations.get(rand.nextInt(possibleMutations.size()));
            boolean bl = doubleMutate = rand.nextFloat() < selected.getChance() * mutationChanceMod;
            if (tracker != null) {
                tracker.discover(selected);
            }
            if ((double)rand.nextFloat() < 0.5) {
                chromosome_a = selected.getResultSpecies().getDefaultChromosome().copy();
                if (doubleMutate) {
                    chromosome_b = chromosome_a.copy();
                }
            } else {
                chromosome_b = selected.getResultSpecies().getDefaultChromosome().copy();
                if (doubleMutate) {
                    chromosome_a = chromosome_b.copy();
                }
            }
        }
        for (Map.Entry<ResourceLocation, IGene<?>> entry : chromosome_a.getGenes().entrySet()) {
            IGene<?> gene = entry.getValue();
            if (!entry.getValue().isDominant()) {
                chromosome_a.setGene(entry.getKey(), chromosome_b.getGene(entry.getKey()));
                chromosome_b.setGene(entry.getKey(), gene);
                continue;
            }
            if (!chromosome_b.getGene(entry.getKey()).isDominant() || !((double)rand.nextFloat() < 0.5)) continue;
            chromosome_a.setGene(entry.getKey(), chromosome_b.getGene(entry.getKey()));
            chromosome_b.setGene(entry.getKey(), gene);
        }
        return new Genome(chromosome_a, chromosome_b);
    }

    public static ItemStack getOffspring(ItemStack bee, Item resultType, Level level, BlockPos pos, float ... mutationModifiers) {
        ItemStack result = new ItemStack((ItemLike)resultType);
        CompoundTag eggs = bee.m_41784_().m_128469_(MATE);
        Genome genome = GeneticHelper.getGenome(bee);
        Genome mate = new Genome(Chromosome.deserialize(eggs.m_128469_(CHROMOSOME_A)), Chromosome.deserialize(eggs.m_128469_(CHROMOSOME_B)));
        if (!eggs.equals((Object)new CompoundTag())) {
            GeneticHelper.setGenome(result, GeneticHelper.mixGenomes(genome, mate, level, pos, mutationModifiers));
        } else {
            GeneticHelper.setGenome(result, genome);
        }
        if (resultType instanceof PrincessItem) {
            PrincessItem.setGeneration(result, QueenItem.getGeneration(bee) + 1);
        }
        GeneticHelper.setSpeciesTag(result);
        return result;
    }

    public static ItemStack createQueenFromPrincessAndDrone(ItemStack princess, ItemStack drone) {
        ItemStack queen = new ItemStack((ItemLike)ItemsRegistration.QUEEN.get());
        GeneticHelper.setGenome(queen, GeneticHelper.getGenome(princess));
        GeneticHelper.setMate(queen, GeneticHelper.getGenome(drone));
        QueenItem.setGeneration(queen, PrincessItem.getGeneration(princess));
        if (princess.m_41783_().m_128441_("analyzed") && princess.m_41783_().m_128471_("analyzed")) {
            queen.m_41784_().m_128379_("analyzed", true);
        }
        return queen;
    }
}

