/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class MachineModifier {
    public static MachineModifier BLANK = new MachineModifier();
    private final float speedMod;
    private final float efficiencyMod;
    private final float outputMod;
    private final int processingMod;

    public MachineModifier(float speedMod, float efficiencyMod, float outputMod, int processingMod) {
        this.speedMod = speedMod;
        this.efficiencyMod = efficiencyMod;
        this.outputMod = outputMod;
        this.processingMod = processingMod;
    }

    public MachineModifier() {
        this(1.0f, 1.0f, 1.0f, 1);
    }

    public static MachineModifier of(MachineModifier ... modifiers) {
        float speedMod = 1.0f;
        float efficiencyMod = 1.0f;
        float outputMod = 1.0f;
        int processingMod = 0;
        for (MachineModifier modifier : modifiers) {
            if (modifier == null) continue;
            speedMod *= modifier.speedMod;
            efficiencyMod *= modifier.efficiencyMod;
            outputMod *= modifier.outputMod;
            processingMod += modifier.processingMod;
        }
        return new MachineModifier(speedMod, efficiencyMod, outputMod, processingMod);
    }

    public float getEfficiencyMod() {
        return this.efficiencyMod;
    }

    public float getOutputMod() {
        return this.outputMod;
    }

    public float getSpeedMod() {
        return this.speedMod;
    }

    public int getProcessingMod() {
        return this.processingMod;
    }

    public List<Component> getTooltipComponents() {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.getSpeedMod() != 1.0f) {
            components.add((Component)Component.m_237115_((String)"upgrade.complicated_bees.speed_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)String.format("%01.2fx", Float.valueOf(this.getSpeedMod())))).m_130940_(ChatFormatting.GRAY));
        }
        if (this.getEfficiencyMod() != 1.0f) {
            components.add((Component)Component.m_237115_((String)"upgrade.complicated_bees.efficiency_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)String.format("%01.2fx", Float.valueOf(this.getEfficiencyMod())))).m_130940_(ChatFormatting.GRAY));
        }
        if (this.getOutputMod() != 1.0f) {
            components.add((Component)Component.m_237115_((String)"upgrade.complicated_bees.output_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)String.format("%01.2fx", Float.valueOf(this.getOutputMod())))).m_130940_(ChatFormatting.GRAY));
        }
        if (this.getProcessingMod() != 0) {
            components.add((Component)Component.m_237115_((String)"upgrade.complicated_bees.processing_label").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)("+" + this.getProcessingMod()))).m_130940_(ChatFormatting.GRAY));
        }
        return components;
    }

    public static class Builder {
        private float speedMod = 1.0f;
        private float efficiencyMod = 1.0f;
        private float outputMod = 1.0f;
        private int processingMod = 0;

        public MachineModifier build() {
            return new MachineModifier(this.speedMod, this.efficiencyMod, this.outputMod, this.processingMod);
        }

        public Builder speed(float mod) {
            this.speedMod = mod;
            return this;
        }

        public Builder efficiency(float mod) {
            this.efficiencyMod = mod;
            return this;
        }

        public Builder output(float mod) {
            this.outputMod = mod;
            return this;
        }

        public Builder processing(int mod) {
            this.processingMod = mod;
            return this;
        }
    }
}

