/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Product {
    public static final Codec<Product> CODEC = Codec.of(Product::encode, Product::decode);
    public static final List<Product> EMPTY = List.of(new Product(Items.f_41852_.m_7968_(), 0.0f));
    public static final Random rand = new Random();
    private final Item item;
    private final int count;
    private final CompoundTag nbt;
    private final TagKey<Item> tag;
    private final float chance;
    private ItemStack cachedStack;

    public Product(Item item, int count, @Nullable CompoundTag nbt, @Nullable TagKey<Item> tag, float chance) {
        this.item = item;
        this.count = count;
        this.nbt = nbt;
        this.tag = tag;
        this.chance = chance;
    }

    public Product(ItemStack stack, float chance) {
        this(stack.m_41720_(), stack.m_41613_(), stack.m_41783_(), null, chance);
    }

    public boolean isTagProduct() {
        return this.tag != null;
    }

    public float getChance() {
        return this.chance;
    }

    public ItemStack getStack() {
        Item resolvedItem;
        if (this.cachedStack != null) {
            return this.cachedStack.m_41777_();
        }
        if (this.isTagProduct()) {
            Optional firstItem = BuiltInRegistries.f_257033_.m_203431_(this.tag).flatMap(set -> set.m_203614_().map(Holder::m_203334_).min(Comparator.comparing(i -> BuiltInRegistries.f_257033_.m_7981_(i).toString())));
            if (firstItem.isEmpty()) {
                ComplicatedBees.LOGGER.error("tag " + String.valueOf(this.tag.f_203868_()) + " is empty or invalid");
                this.cachedStack = ItemStack.f_41583_;
                return this.cachedStack.m_41777_();
            }
            resolvedItem = (Item)firstItem.get();
        } else {
            resolvedItem = this.item;
        }
        ItemStack stack = new ItemStack((ItemLike)resolvedItem, this.count);
        if (this.nbt != null) {
            stack.m_41751_(this.nbt.m_6426_());
        }
        this.cachedStack = stack;
        return this.cachedStack.m_41777_();
    }

    public ItemStack getStackResult(float ... modifiers) {
        ItemStack stack;
        float stackChance = this.getChance();
        for (float modifier : modifiers) {
            stackChance *= modifier;
        }
        if (stackChance > 1.0f) {
            stack = this.getStack();
            stack.m_41764_((int)stackChance * stack.m_41613_());
            stack.m_41769_(rand.nextFloat() < stackChance - (float)((int)stackChance) ? this.getStack().m_41613_() : 0);
        } else {
            stack = rand.nextFloat() < stackChance ? this.getStack() : ItemStack.f_41583_;
        }
        return stack;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isTagProduct());
        buf.writeInt(this.count);
        buf.writeFloat(this.chance);
        buf.m_130079_(this.nbt);
        if (this.isTagProduct()) {
            buf.m_130085_(this.tag.f_203868_());
        } else {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (Object)this.item);
        }
    }

    public static Product fromNetwork(FriendlyByteBuf buf) {
        boolean isTag = buf.readBoolean();
        int count = buf.readInt();
        float chance = buf.readFloat();
        CompoundTag nbt = buf.m_130260_();
        if (isTag) {
            ResourceLocation tagId = buf.m_130281_();
            TagKey tag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagId);
            return new Product(Items.f_41852_, count, nbt, (TagKey<Item>)tag, chance);
        }
        Item item = (Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (nbt != null) {
            stack.m_41751_(nbt);
        }
        return new Product(stack, chance);
    }

    private <T> DataResult<T> encode(DynamicOps<T> ops, T prefix) {
        RecordBuilder builder = ops.mapBuilder();
        if (this.isTagProduct()) {
            builder.add("tag", ResourceLocation.f_135803_.encodeStart(ops, (Object)this.tag.f_203868_()).result().orElse(ops.empty()));
        } else {
            builder.add("item", BuiltInRegistries.f_257033_.m_194605_().encodeStart(ops, (Object)this.item));
        }
        if (this.nbt != null && !this.nbt.m_128456_()) {
            builder.add("nbt", CompoundTag.f_128325_.encodeStart(ops, (Object)this.nbt).result().orElseThrow());
        }
        if (this.count > 1) {
            builder.add("count", ops.createInt(this.count));
        }
        if (this.chance != 1.0f) {
            builder.add("chance", ops.createFloat(this.chance));
        }
        return builder.build(prefix);
    }

    private static <T> DataResult<Pair<Product, T>> decode(DynamicOps<T> ops, T input) {
        Optional item = ops.get(input, "item").result();
        Optional tag = ops.get(input, "tag").result();
        int count = ops.get(input, "count").flatMap(data -> Codec.INT.parse(ops, data)).result().orElse(1);
        float chance = ops.get(input, "chance").flatMap(data -> Codec.FLOAT.parse(ops, data)).result().orElse(Float.valueOf(1.0f)).floatValue();
        CompoundTag nbt = ops.get(input, "nbt").flatMap(data -> CompoundTag.f_128325_.parse(ops, data)).result().orElse(new CompoundTag());
        if (item.isEmpty() && tag.isEmpty()) {
            return DataResult.error(() -> "Expected either 'item' or 'tag' field");
        }
        if (item.isPresent()) {
            return BuiltInRegistries.f_257033_.m_194605_().parse(ops, item.get()).map(i -> {
                ItemStack stack = new ItemStack((ItemLike)i, count);
                if (!nbt.m_128456_()) {
                    stack.m_41751_(nbt);
                }
                return Pair.of((Object)new Product(stack, chance), (Object)input);
            });
        }
        return ResourceLocation.f_135803_.xmap(loc -> TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)loc), TagKey::f_203868_).parse(ops, tag.get()).flatMap(tagKey -> {
            CompoundTag copyNbt = nbt.m_128456_() ? null : nbt.m_6426_();
            return DataResult.success((Object)Pair.of((Object)new Product(Items.f_41852_, count, copyNbt, (TagKey<Item>)tagKey, chance), (Object)input));
        });
    }
}

