/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.effect;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.IBeeHousing;
import com.accbdd.complicated_bees.bees.effect.IBeeEffect;
import com.accbdd.complicated_bees.bees.gene.GeneTerritory;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.util.BlockPosBoxIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BeeEffect
implements IBeeEffect {
    @Override
    public abstract void runEffect(BlockEntity var1, ItemStack var2, int var3);

    protected List<Entity> getTerritoryEntities(BlockEntity be, ItemStack queen) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        Vec3 center = be.m_58899_().m_252807_();
        float rangeModifier = 1.0f;
        if (be instanceof IBeeHousing) {
            IBeeHousing housing = (IBeeHousing)be;
            for (BeeHousingModifier modifier : housing.getHousingModifiers()) {
                rangeModifier *= modifier.getTerritoryMod();
            }
        }
        int[] radii = (int[])GeneticHelper.getGeneValue(queen, GeneTerritory.ID, true);
        Vec3 offset = new Vec3((double)((float)radii[0] * rangeModifier), (double)((float)radii[1] * rangeModifier), (double)((float)radii[0] * rangeModifier));
        for (Entity entity : Objects.requireNonNull(be.m_58904_()).m_45933_(null, new AABB(center.m_82549_(offset), center.m_82546_(offset)))) {
            Player player;
            if (entity instanceof Player && this.hasApiaristArmorEquipped(player = (Player)entity)) continue;
            entities.add(entity);
        }
        return entities;
    }

    protected BlockPosBoxIterator getBlockIterator(BlockEntity be, ItemStack queen) {
        float rangeModifier = 1.0f;
        if (be instanceof IBeeHousing) {
            IBeeHousing housing = (IBeeHousing)be;
            for (BeeHousingModifier modifier : housing.getHousingModifiers()) {
                rangeModifier *= modifier.getTerritoryMod();
            }
        }
        int[] radii = (int[])GeneticHelper.getGeneValue(queen, GeneTerritory.ID, true);
        return new BlockPosBoxIterator(be.m_58899_(), Math.round((float)radii[0] * rangeModifier), Math.round((float)radii[1] * rangeModifier));
    }

    private boolean hasApiaristArmorEquipped(Player player) {
        Inventory inv = player.m_150109_();
        return inv.m_36052_(0).m_150930_((Item)ItemsRegistration.APIARIST_BOOTS.get()) && inv.m_36052_(1).m_150930_((Item)ItemsRegistration.APIARIST_LEGGINGS.get()) && inv.m_36052_(2).m_150930_((Item)ItemsRegistration.APIARIST_CHESTPLATE.get()) && inv.m_36052_(3).m_150930_((Item)ItemsRegistration.APIARIST_HELMET.get());
    }
}

