/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.bees.mutation;

import com.accbdd.complicated_bees.ComplicatedBees;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.bees.mutation.condition.IMutationCondition;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class Mutation {
    private final ResourceLocation first;
    private final ResourceLocation second;
    private final ResourceLocation result;
    private final float chance;
    private final List<IMutationCondition> conditions;
    public static final Codec<Mutation> MUTATION_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("first").forGetter(Mutation::getFirst), (App)ResourceLocation.f_135803_.fieldOf("second").forGetter(Mutation::getSecond), (App)ResourceLocation.f_135803_.fieldOf("result").forGetter(Mutation::getResult), (App)Codec.FLOAT.fieldOf("chance").forGetter(Mutation::getChance), (App)CompoundTag.f_128325_.optionalFieldOf("conditions", (Object)new CompoundTag()).forGetter(mutation -> Mutation.getSerializedConditions(mutation.getConditions()))).apply((Applicative)instance, Mutation::new));

    public Mutation(ResourceLocation first, ResourceLocation second, ResourceLocation result, float chance, List<IMutationCondition> conditions) {
        this.first = first;
        this.second = second;
        this.result = result;
        this.chance = chance;
        this.conditions = conditions;
    }

    public Mutation(ResourceLocation first, ResourceLocation second, ResourceLocation result, float chance, CompoundTag conditions) {
        this(first, second, result, chance, new ArrayList<IMutationCondition>());
        List<IMutationCondition> list = this.getConditions();
        for (String key : conditions.m_128431_()) {
            IMutationCondition condition = (IMutationCondition)ComplicatedBees.MUTATION_CONDITION_REGISTRY.get().getValue(ResourceLocation.m_135820_((String)key));
            if (condition != null) {
                list.add(condition.deserialize(conditions.m_128469_(key)));
                continue;
            }
            ComplicatedBees.LOGGER.error("could not find condition {}", (Object)key);
        }
    }

    public ResourceLocation getFirst() {
        return this.first;
    }

    public Species getFirstSpecies() {
        return SpeciesRegistration.getFromResourceLocation(this.first);
    }

    public ResourceLocation getSecond() {
        return this.second;
    }

    public Species getSecondSpecies() {
        return SpeciesRegistration.getFromResourceLocation(this.second);
    }

    public ResourceLocation getResult() {
        return this.result;
    }

    public Species getResultSpecies() {
        return SpeciesRegistration.getFromResourceLocation(this.result);
    }

    public float getChance() {
        return this.chance;
    }

    public List<IMutationCondition> getConditions() {
        return this.conditions;
    }

    public static CompoundTag getSerializedConditions(List<IMutationCondition> conditions) {
        CompoundTag tag = new CompoundTag();
        for (IMutationCondition condition : conditions) {
            ResourceLocation loc = condition.getID();
            if (loc == null) {
                ComplicatedBees.LOGGER.error("tried to serialize mutation with no id! description: {}", (Object)condition.getDescription());
                continue;
            }
            tag.m_128365_(loc.toString(), (Tag)condition.serialize());
        }
        return tag;
    }
}

