/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import net.minecraftforge.energy.IEnergyStorage;

public class CombinedEnergyStorage
implements IEnergyStorage {
    private final IEnergyStorage[] storages;

    public CombinedEnergyStorage(IEnergyStorage ... storages) {
        this.storages = storages;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int toInsert = maxReceive;
        for (IEnergyStorage storage : this.storages) {
            if (maxReceive <= 0) break;
            maxReceive -= storage.receiveEnergy(maxReceive, simulate);
        }
        return toInsert - maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = maxExtract;
        for (IEnergyStorage storage : this.storages) {
            if (maxExtract <= 0) break;
            maxExtract -= storage.extractEnergy(maxExtract, simulate);
        }
        return extracted - maxExtract;
    }

    public int getEnergyStored() {
        int stored = 0;
        for (IEnergyStorage storage : this.storages) {
            stored += storage.getEnergyStored();
        }
        return stored;
    }

    public int getMaxEnergyStored() {
        int maxStored = 0;
        for (IEnergyStorage storage : this.storages) {
            maxStored += storage.getMaxEnergyStored();
        }
        return maxStored;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }
}

