/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity;

import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.datagen.ItemTagGenerator;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MicroscopeBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "items";
    private final ItemStackHandler items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.items));
    private boolean locked = false;

    public MicroscopeBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntitiesRegistration.MICROSCOPE_BLOCK_ENTITY.get(), pos, state);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(6){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return slot == 0 ? stack.m_204117_(ItemTagGenerator.BEE) : stack.m_204117_(ItemTagGenerator.RESEARCH_MATERIAL);
            }

            protected void onContentsChanged(int slot) {
                MicroscopeBlockEntity.this.markDirty();
            }
        };
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ITEMS_TAG, (Tag)this.items.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ITEMS_TAG)) {
            this.items.deserializeNBT(tag.m_128469_(ITEMS_TAG));
        }
    }

    public LazyOptional<IItemHandler> getItemHandler() {
        return this.itemHandler;
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public void markDirty() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

