/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.mellarium;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.bees.BeeLogic;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.block.entity.BaseBeeHousing;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumModifier;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumTickable;
import com.accbdd.complicated_bees.item.BeeItem;
import com.accbdd.complicated_bees.item.DroneItem;
import com.accbdd.complicated_bees.item.PrincessItem;
import com.accbdd.complicated_bees.item.QueenItem;
import com.accbdd.complicated_bees.multiblock.MellariumLogic;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.util.MultiblockHelper;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class MellariumControllerBlockEntity
extends BaseBeeHousing {
    public static final int BEE_SLOT = 0;
    public static final int BEE_SLOT_COUNT = 2;
    public static final int OUTPUT_SLOT = 0;
    public static final int OUTPUT_SLOT_COUNT = 7;
    public static final int SLOT_COUNT = 9;
    private MellariumLogic mellariumLogic;
    BeeLogic beeLogic;
    private final Stack<ItemStack> outputBuffer = new Stack();
    private final ItemStackHandler beeItems = this.createBeeHandler();
    private final ItemStackHandler outputItems = this.createOutputHandler();
    private final ItemStackHandler frameItems = new ItemStackHandler(0);
    private final LazyOptional<IItemHandlerModifiable> beeItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.beeItems){

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }
    });
    private final LazyOptional<IItemHandlerModifiable> outputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.outputItems){

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    });
    private final LazyOptional<IItemHandlerModifiable> itemHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.beeItemHandler.resolve().get(), (IItemHandlerModifiable)this.outputItemHandler.resolve().get()}));

    public MellariumControllerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        this(pPos, pBlockState, null);
    }

    public MellariumControllerBlockEntity(BlockPos pPos, BlockState pBlockState, MellariumLogic mellariumLogic) {
        super(BlockEntitiesRegistration.MELLARIUM_CONTROLLER_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.mellariumLogic = mellariumLogic;
        if (mellariumLogic != null) {
            this.setOwner(mellariumLogic.getOwner());
        }
        this.beeLogic = new BeeLogic(this.m_58904_(), this.m_58899_(), this);
    }

    private ItemStackHandler createOutputHandler() {
        return new ItemStackHandler(7){

            protected void onContentsChanged(int slot) {
                MellariumControllerBlockEntity.this.m_6596_();
            }
        };
    }

    private ItemStackHandler createBeeHandler() {
        return new ItemStackHandler(2){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (stack.m_41720_() instanceof BeeItem) {
                    switch (slot) {
                        case 0: {
                            return stack.m_41720_() instanceof QueenItem || stack.m_41720_() instanceof PrincessItem;
                        }
                        case 1: {
                            return stack.m_41720_() instanceof DroneItem;
                        }
                    }
                }
                return false;
            }

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                if (slot == 0) {
                    MellariumControllerBlockEntity.this.getLogic().setQueen(this.getStackInSlot(0));
                    MellariumControllerBlockEntity.this.getLogic().clearFlowerCache();
                    MellariumControllerBlockEntity.this.getLogic().checkConditions();
                }
                MellariumControllerBlockEntity.this.m_6596_();
            }
        };
    }

    @Override
    public ItemStackHandler getBeeItems() {
        return this.beeItems;
    }

    @Override
    public ItemStackHandler getOutputItems() {
        return this.outputItems;
    }

    @Override
    public ItemStackHandler getFrameItems() {
        return this.frameItems;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getItemHandler() {
        return this.itemHandler;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getBeeItemHandler() {
        return this.beeItemHandler;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getOutputItemHandler() {
        return this.outputItemHandler;
    }

    @Override
    public LazyOptional<IItemHandlerModifiable> getFrameItemHandler() {
        return LazyOptional.empty();
    }

    @Override
    public Stack<ItemStack> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public BeeLogic getLogic() {
        return this.beeLogic;
    }

    @Override
    public void setOwner(UUID owner) {
        super.setOwner(owner);
        if (this.mellariumLogic != null) {
            this.mellariumLogic.setOwner(owner);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.getMellariumLogic() == null) {
            return;
        }
        this.getMellariumLogic().getSpecialBlocks().stream().forEach(pos -> {
            BlockEntity patt6071$temp = this.m_58904_().m_7702_(pos);
            if (patt6071$temp instanceof IMellariumTickable) {
                IMellariumTickable tickable = (IMellariumTickable)patt6071$temp;
                tickable.onTick();
            }
        });
    }

    @Override
    public void beeTick() {
        super.beeTick();
        this.getMellariumLogic().getSpecialBlocks().stream().forEach(pos -> {
            BlockEntity patt6368$temp = this.m_58904_().m_7702_(pos);
            if (patt6368$temp instanceof IMellariumTickable) {
                IMellariumTickable tickable = (IMellariumTickable)patt6368$temp;
                tickable.onBeeTick();
            }
        });
    }

    @Override
    public void produceOffspring(ItemStack queen, BlockPos pos) {
        super.produceOffspring(queen, this.m_58899_().m_7495_());
        this.getMellariumLogic().getSpecialBlocks().stream().forEach(specialPos -> {
            BlockEntity patt6813$temp = this.m_58904_().m_7702_(specialPos);
            if (patt6813$temp instanceof IMellariumTickable) {
                IMellariumTickable tickable = (IMellariumTickable)patt6813$temp;
                tickable.onDeath();
            }
        });
    }

    @Override
    public void generateProduce(ItemStack bee) {
        super.generateProduce(bee);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.mellariumLogic == null && MultiblockHelper.isValidMellarium(this.m_58904_(), this.m_58899_())) {
            MultiblockHelper.buildMellarium(this.m_58904_(), this.m_58899_(), this.getOwner());
        }
        this.getLogic().setPos(this.getLogic().getPos().m_7494_());
        this.m_6596_();
    }

    public MellariumLogic getMellariumLogic() {
        if (this.mellariumLogic == null && MultiblockHelper.isValidMellarium(this.m_58904_(), this.m_58899_())) {
            MultiblockHelper.buildMellarium(this.m_58904_(), this.m_58899_(), this.getOwner());
        }
        return this.mellariumLogic;
    }

    public void setMellariumLogic(MellariumLogic logic) {
        this.mellariumLogic = logic;
    }

    @Override
    public void damageFrames() {
    }

    @Override
    public List<BeeHousingModifier> getHousingModifiers() {
        if (this.getMellariumLogic() == null) {
            return List.of();
        }
        List<BeeHousingModifier> list = this.getMellariumLogic().getSpecialBlocks().stream().map(pos -> {
            BlockEntity patt8188$temp = this.m_58904_().m_7702_(pos);
            if (patt8188$temp instanceof IMellariumModifier) {
                IMellariumModifier modifier = (IMellariumModifier)patt8188$temp;
                return modifier.getModifier();
            }
            return new BeeHousingModifier();
        }).collect(Collectors.toList());
        list.add(new BeeHousingModifier.Builder().productivity(1.25f).build());
        return list;
    }

    public LazyOptional<IEnergyStorage> getEnergyHandler() {
        return LazyOptional.of(() -> this.getMellariumLogic().getEnergyStorage());
    }
}

