/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.mellarium;

import com.accbdd.complicated_bees.block.entity.mellarium.AbstractMellariumBlockEntity;
import com.accbdd.complicated_bees.config.ServerConfig;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MellariumEnergyCellBlockEntity
extends AbstractMellariumBlockEntity {
    public static final int BASE_STORAGE = (Integer)ServerConfig.SERVER_CONFIG.mellariumCellStorage.get();
    public static final int BASE_TRANSFER = (Integer)ServerConfig.SERVER_CONFIG.mellariumCellTransfer.get();
    public static final String ENERGY_TAG = "energy";
    private final LazyOptional<IEnergyStorage> energyHandler;
    private final EnergyStorage energy = new EnergyStorage(BASE_STORAGE, BASE_TRANSFER);

    public MellariumEnergyCellBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.MELLARIUM_ENERGY_CELL_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.energyHandler = LazyOptional.of(() -> this.energy);
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_(ENERGY_TAG, this.energy.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_(ENERGY_TAG)) {
            this.energy.deserializeNBT(tag.m_128423_(ENERGY_TAG));
        }
    }
}

