/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.block.entity.mellarium;

import com.accbdd.complicated_bees.bees.BeeHousingModifier;
import com.accbdd.complicated_bees.block.entity.AdaptedItemHandler;
import com.accbdd.complicated_bees.block.entity.mellarium.AbstractMellariumBlockEntity;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumModifier;
import com.accbdd.complicated_bees.block.entity.mellarium.IMellariumTickable;
import com.accbdd.complicated_bees.recipe.HydroRecipe;
import com.accbdd.complicated_bees.registry.BlockEntitiesRegistration;
import com.accbdd.complicated_bees.registry.EsotericRegistration;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MellariumHydroregulatorBlockEntity
extends AbstractMellariumBlockEntity
implements IMellariumModifier,
IMellariumTickable {
    private static final String ITEMS_TAG = "Items";
    private final ItemStackHandler inputItems;
    private final ItemStackHandler outputItems;
    private final LazyOptional<IItemHandlerModifiable> inputItemHandler;
    private final LazyOptional<IItemHandlerModifiable> outputItemHandler;
    private final LazyOptional<IItemHandlerModifiable> itemHandler;
    private final RecipeManager.CachedCheck<Container, HydroRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)EsotericRegistration.HYDROREGULATOR_RECIPE.get()));

    public MellariumHydroregulatorBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntitiesRegistration.MELLARIUM_HYDROREGULATOR_BLOCK_ENTITY.get(), pPos, pBlockState);
        this.inputItems = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return MellariumHydroregulatorBlockEntity.this.hasRecipe(stack);
            }
        };
        this.outputItems = new ItemStackHandler(1);
        this.inputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.inputItems){

            @Override
            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }
        });
        this.outputItemHandler = LazyOptional.of(() -> new AdaptedItemHandler((IItemHandlerModifiable)this.outputItems){

            @Override
            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }
        });
        this.itemHandler = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{(IItemHandlerModifiable)this.inputItemHandler.resolve().get(), (IItemHandlerModifiable)this.outputItemHandler.resolve().get()}));
    }

    private boolean hasRecipe(ItemStack stack) {
        AtomicBoolean test = new AtomicBoolean(false);
        this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.m_58904_()).ifPresent(recipe -> test.set(this.canRecipeOutput((HydroRecipe)recipe)));
        return test.get();
    }

    private boolean canRecipeOutput(HydroRecipe recipe) {
        return this.outputItems.insertItem(0, recipe.getOutput().getStack(), true).m_41619_();
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.getLogic() == null || this.getLogic().getController() == null) {
            return super.getCapability(cap, side);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.getItemHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.getItemHandler().invalidate();
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_(ITEMS_TAG, (Tag)this.inputItems.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_(ITEMS_TAG)) {
            this.inputItems.deserializeNBT(pTag.m_128469_(ITEMS_TAG));
        }
    }

    @Override
    public BeeHousingModifier getModifier() {
        ItemStack stack = this.inputItems.getStackInSlot(0);
        if (this.hasRecipe(stack)) {
            return new BeeHousingModifier.Builder().humidity(((HydroRecipe)this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.m_58904_()).get()).getHumidityChange()).build();
        }
        return new BeeHousingModifier();
    }

    @Override
    public void onBeeTick() {
        ItemStack stack = this.inputItems.getStackInSlot(0);
        this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.m_58904_()).ifPresent(recipe -> {
            if (this.f_58857_.m_213780_().m_188501_() < recipe.getUseChance()) {
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    this.getLogic().getController().getLogic().clearConditionCache();
                    this.getLogic().getController().getLogic().checkConditions();
                }
                this.outputItems.insertItem(0, recipe.getOutput().getStackResult(new float[0]), false);
            }
        });
    }

    public ItemStackHandler getInputItems() {
        return this.inputItems;
    }

    public LazyOptional<IItemHandlerModifiable> getItemHandler() {
        return this.itemHandler;
    }
}

