/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.client;

import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public class BeeModel
implements IUnbakedGeometry<BeeModel> {
    public static HashMap<ResourceLocation, Variant> cacheMap = new HashMap();

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new Baked();
    }

    private static class Baked
    implements BakedModel {
        private Baked() {
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState pState, @Nullable Direction pDirection, RandomSource pRandom) {
            return List.of();
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return null;
        }

        public ItemOverrides m_7343_() {
            return OverrideList.INSTANCE;
        }

        public static class OverrideList
        extends ItemOverrides {
            public static OverrideList INSTANCE = new OverrideList();
            private static final Map<Integer, BakedModel> stackCache = new LinkedHashMap<Integer, BakedModel>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Integer, BakedModel> eldest) {
                    return this.size() > 2000;
                }
            };

            @Nullable
            public BakedModel m_173464_(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
                Variant variant;
                int stackHash = this.getStackHash(pStack);
                BakedModel cached = stackCache.get(stackHash);
                if (cached != null) {
                    return cached;
                }
                ResourceLocation speciesLoc = GeneticHelper.getSpeciesLoc(pStack);
                if (speciesLoc == null) {
                    Minecraft.m_91087_().m_91304_().getModel(Species.DEFAULT_MODELS.get(0));
                }
                if ((variant = cacheMap.get(speciesLoc)) == null) {
                    Species species = GeneticHelper.getSpecies(pStack, true);
                    if (species == null) {
                        variant = new Variant(Minecraft.m_91087_().m_91304_().m_119409_(), Minecraft.m_91087_().m_91304_().m_119409_(), Minecraft.m_91087_().m_91304_().m_119409_());
                    } else {
                        BakedModel droneModel = Minecraft.m_91087_().m_91304_().getModel(species.getModels().get(0));
                        BakedModel princessModel = Minecraft.m_91087_().m_91304_().getModel(species.getModels().get(1));
                        BakedModel queenModel = Minecraft.m_91087_().m_91304_().getModel(species.getModels().get(2));
                        variant = new Variant(droneModel, princessModel, queenModel);
                    }
                    cacheMap.put(speciesLoc, variant);
                }
                cached = pStack.m_150930_((Item)ItemsRegistration.QUEEN.get()) ? variant.queen : (pStack.m_150930_((Item)ItemsRegistration.PRINCESS.get()) ? variant.princess : variant.drone);
                stackCache.put(stackHash, cached);
                return cached;
            }

            private int getStackHash(ItemStack stack) {
                String species;
                CompoundTag tag = stack.m_41783_();
                String string = species = tag != null && tag.m_128441_("species") ? tag.m_128461_("species") : "none";
                int type = stack.m_150930_((Item)ItemsRegistration.QUEEN.get()) ? 2 : (stack.m_150930_((Item)ItemsRegistration.PRINCESS.get()) ? 1 : 0);
                return Objects.hash(species, type);
            }
        }
    }

    public static class Builder
    extends ModelBuilder<Builder> {
        public Builder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
            super(outputLocation, existingFileHelper);
        }

        public JsonObject toJson() {
            JsonObject root = new JsonObject();
            root.addProperty("loader", Loader.ID.toString());
            return root;
        }
    }

    public static class Loader
    implements IGeometryLoader<BeeModel> {
        public static final ResourceLocation ID = ResourceLocation.m_214293_((String)"complicated_bees", (String)"bee_model");

        public BeeModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) throws JsonParseException {
            return new BeeModel();
        }
    }

    public record Variant(BakedModel drone, BakedModel princess, BakedModel queen) {
    }
}

