/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.ingredient;

import com.accbdd.complicated_bees.ComplicatedBees;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.injection.invoke.arg.ArgumentIndexOutOfBoundsException;

public class EmiBlock
extends EmiStack {
    private final Block block;
    private final ItemStack stack;

    public EmiBlock(Block block) {
        this.block = block;
        this.stack = block.m_5456_().m_7968_();
    }

    public List<EmiStack> getEmiStacks() {
        return this.stack.m_41619_() ? List.of(this) : List.of(EmiStack.of((ItemStack)this.stack));
    }

    public EmiStack copy() {
        return new EmiBlock(this.block);
    }

    public boolean isEmpty() {
        return false;
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.block;
    }

    public ResourceLocation getId() {
        return ForgeRegistries.BLOCKS.getKey((Object)this.block);
    }

    public List<Component> getTooltipText() {
        return List.of(this.block.m_49954_());
    }

    public List<ClientTooltipComponent> getTooltip() {
        return List.of(new ClientTextTooltip(this.block.m_49954_().m_7532_()));
    }

    public Component getName() {
        return this.block.m_49954_();
    }

    public void render(GuiGraphics draw, int x, int y, float delta) {
        this.render(draw, x, y, delta, 0);
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        try {
            if (this.block.m_5456_() != Items.f_41852_) {
                draw.m_280203_(this.stack, x, y);
            } else {
                ModelManager manager = Minecraft.m_91087_().m_91304_();
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null) {
                    ResourceLocation loc = ((Registry)level.m_9598_().m_6632_(Registries.f_256747_).orElseThrow()).m_7981_((Object)this.block);
                    if (loc != null) {
                        TextureAtlasSprite sprite = manager.m_119430_().m_110893_(this.block.m_49966_()).getParticleIcon(ModelData.EMPTY);
                        draw.m_280159_(x, y, 0, 16, 16, sprite);
                    } else {
                        ComplicatedBees.LOGGER.debug("Error parsing block: {} for EMI plugin.", (Object)this.block.m_49954_().getString());
                    }
                }
            }
        }
        catch (IllegalArgumentException | ArgumentIndexOutOfBoundsException e) {
            ComplicatedBees.LOGGER.error("Block [{}] was handled badly and may not render properly in recipe viewers.", (Object)this.block.m_49954_().getString());
        }
    }
}

