/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.ingredient;

import com.accbdd.complicated_bees.bees.Flower;
import com.accbdd.complicated_bees.bees.GeneticHelper;
import com.accbdd.complicated_bees.compat.emi.ingredient.EmiBlock;
import com.accbdd.complicated_bees.registry.FlowerRegistration;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EmiFlower
extends EmiStack {
    private final List<EmiStack> stacks;
    private final Flower flower;

    public EmiFlower(Flower flower) {
        this.flower = flower;
        this.stacks = new ArrayList<EmiStack>();
        this.stacks.addAll(flower.getAllFlowerBlocks().stream().map(EmiBlock::new).toList());
    }

    public EmiStack copy() {
        return new EmiFlower(this.flower);
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        if (!this.stacks.isEmpty()) {
            this.stacks.get(0).render(draw, x, y, delta, flags);
            RenderSystem.disableDepthTest();
            RenderSystem.enableBlend();
            draw.m_280163_(ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)"textures/item/flower_overlay.png"), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.flower;
    }

    public ResourceLocation getId() {
        return ((Registry)GeneticHelper.getRegistryAccess().m_6632_(FlowerRegistration.FLOWER_REGISTRY_KEY).get()).m_7981_((Object)this.flower);
    }

    public List<Component> getTooltipText() {
        return List.of(GeneticHelper.getTranslationKey(this.flower));
    }

    public Component getName() {
        return GeneticHelper.getTranslationKey(this.flower);
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList<ClientTooltipComponent> list = new ArrayList<ClientTooltipComponent>();
        list.add((ClientTooltipComponent)new ClientTextTooltip(this.getName().m_7532_()));
        list.add((ClientTooltipComponent)new ClientTextTooltip(Component.m_237115_((String)"gui.complicated_bees.jei.bee_flower").m_130940_(ChatFormatting.GOLD).m_7532_()));
        EmiTooltipComponents.appendModName(list, (String)this.getId().m_135827_());
        return list;
    }
}

