/*
 * Decompiled with CFR 0.152.
 */
package com.accbdd.complicated_bees.compat.emi.recipe;

import com.accbdd.complicated_bees.bees.Species;
import com.accbdd.complicated_bees.compat.emi.ComplicatedBeesEMI;
import com.accbdd.complicated_bees.registry.ItemsRegistration;
import com.accbdd.complicated_bees.registry.SpeciesRegistration;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BeeProduceEmiRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final EmiIngredient beeInput;
    private final List<EmiStack> products;
    private final List<EmiStack> specialtyProducts;
    private final List<EmiIngredient> catalysts;

    public BeeProduceEmiRecipe(Species species) {
        ResourceLocation speciesId = Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(SpeciesRegistration.SPECIES_REGISTRY_KEY).m_7981_((Object)species);
        this.id = ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)("/bee_produce/" + speciesId.toString().replace(":", "/")));
        this.beeInput = EmiStack.of((ItemStack)species.toStack((Item)ItemsRegistration.QUEEN.get()));
        this.products = species.getProducts().stream().map(p -> {
            EmiStack test = EmiStack.of((ItemStack)p.getStack()).setChance(p.getChance());
            if (p.getStack().m_150930_((Item)ItemsRegistration.COMB.get())) {
                return test.comparison(Comparison.compareNbt());
            }
            return test;
        }).toList();
        this.specialtyProducts = species.getSpecialtyProducts().stream().map(p -> {
            EmiStack test = EmiStack.of((ItemStack)p.getStack()).setChance(p.getChance());
            if (p.getStack().m_150930_((Item)ItemsRegistration.COMB.get())) {
                return test.comparison(Comparison.compareNbt());
            }
            return test;
        }).toList();
        this.catalysts = new ArrayList<EmiIngredient>();
        this.catalysts.addAll(species.toMembers().stream().map(EmiStack::of).toList());
    }

    public EmiRecipeCategory getCategory() {
        return ComplicatedBeesEMI.BEE_PRODUCE_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.beeInput);
    }

    public List<EmiStack> getOutputs() {
        return Stream.concat(this.products.stream(), this.specialtyProducts.stream()).toList();
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public int getDisplayWidth() {
        return 160;
    }

    public int getDisplayHeight() {
        return 64;
    }

    public void addWidgets(WidgetHolder widgets) {
        int i;
        widgets.addTexture(ResourceLocation.fromNamespaceAndPath((String)"complicated_bees", (String)"textures/gui/jei/bee_products.png"), 0, 0, 160, 64, 0, 0, 160, 64, 160, 64);
        widgets.addSlot(this.beeInput, 13, 23).drawBack(false);
        for (i = 0; i < this.products.size(); ++i) {
            widgets.addSlot((EmiIngredient)this.products.get(i), 65 + 18 * i, 13).recipeContext((EmiRecipe)this);
        }
        for (i = 0; i < this.specialtyProducts.size(); ++i) {
            widgets.addSlot((EmiIngredient)this.specialtyProducts.get(i), 65 + 18 * i, 34).recipeContext((EmiRecipe)this);
        }
    }
}

